<?php

class ArmazemModel extends Database
{

	protected function insertArmazem($idUsuario, $nome, $stockMinimo, $stockNegativo, $nota)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO armazem (idUsuario, nome, stockMinimo, stockNegativo, nota) VALUES (?, ?, ?, ?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idUsuario, $nome, $stockMinimo, $stockNegativo, $nota)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editArmazem($idArmazem, $idUsuario, $nome, $stockMinimo, $stockNegativo, $nota)
	{
		$sql = "UPDATE armazem SET idUsuario = ?, nome = ?, stockMinimo = ?, stockNegativo = ?, nota = ? WHERE idArmazem = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute(array($idUsuario, $nome, $stockMinimo, $stockNegativo, $nota, $idArmazem))) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	public function parentArmazem()
	{
		$data = null;
		$sql = "SELECT * FROM armazem";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readCodigoArmazem()
	{
		$data = null;
		$sql = "SELECT COALESCE(MAX(idArmazem), 0) + 1 AS contador FROM armazem";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryArmazem($idArmazem)
	{
		$data = null;
		$sql = "SELECT * FROM armazem WHERE idArmazem = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArmazem]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemArmazem()
	{
		$data = null;
		$sql = "SELECT * FROM armazem";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function tipopatrimonio()
	{
		$data = null;
		$sql = "SELECT * FROM tipopatrimonio";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function deleteArmazem($idArmazem)
	{
		$sql = "DELETE FROM armazem WHERE idArmazem = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute([$idArmazem])) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	protected function selectArmazem()
	{
		$sql = "SELECT * FROM armazem";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<option name="idArmazem" value="' . $row['idArmazem'] . '">' . $row['nome'] . '</option>'; //'<option value='"$row['idArmazem']"'>'"$row['nome']"'</option>';
			//echo $row['idUsuario'];
			//echo $row['nome'];
		}
	}

	protected function listaArmazem()
	{
		$sql = "SELECT * FROM armazem";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<tr>
					<td>' . $row['idArmazem'] . '</td>
					<td>' . $row['nome'] . '</td>
					<td>
						<a href="../includes/ArmazemUpdate.inc.php?id=' . $row['idArmazem'] . '" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/ArmazemDelete.inc.php?id=' . $row['idArmazem'] . '"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
		}
	}

	public function autoIncrementArmazem()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'armazem';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}

	protected function countArmazem()
	{
		$sql = "SELECT COUNT(*) FROM armazem";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		echo $results['COUNT(*)'];
	}
}
