<?php
    class ArtigoDocumentoModel extends Database {

		protected function insertArtigoDocumento($idDocumento, $idArtigo, $descricao, $qtd, $preco, $desconto, $idImposto, $imposto, $total){
            $stmt = $this->connect();
            $sql = "INSERT INTO artigoDocumento (idDocumento, idArtigo, descricao, qtd, preco, desconto, idImposto, imposto, total) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idDocumento, $idArtigo, $descricao, $qtd, $preco, $desconto, $idImposto, $imposto, $total)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemArtigoDocumento(){
			$data = null;
			$sql = "SELECT * FROM artigoDocumento";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryArtigoDocumento($idArtigoDocumento){
			$data = null;
			$sql = "SELECT * FROM artigoDocumento WHERE idArtigoDocumento = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idArtigoDocumento]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listagemArtigo(){
			$data = null;
			$sql = "SELECT * FROM viewartigo";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editArtigoDocumento($idArtigoDocumento, $idDocumento, $idArtigo, $descricao, $qtd, $preco, $desconto, $idImposto, $imposto, $total){
			$stmt = $this->connect();
			
            $sql = "UPDATE artigoDocumento SET idDocumento = ?, idArtigo = ?, descricao = ?, qtd = ?, preco = ?, desconto = ?, idTaxa = ?, imposto = ?, total = ? WHERE idArtigoDocumento = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idDocumento, $idArtigo, $descricao, $qtd, $preco, $desconto, $idImposto, $imposto, $total, $idArtigoDocumento)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteArtigoDocumento($idArtigoDocumento){
			$stmt = $this->connect();
            $sql = "DELETE FROM artigoDocumento WHERE idArtigoDocumento = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idArtigoDocumento)))){
				$query = null;
				exit();
			}
		}
    }