<?php

class CarroModel extends Database {

		protected function insertCarro($idUsuario, $idFamilia, $nome, $preco, $matricula){
            $stmt = $this->connect();
            $sql = "INSERT INTO carro (idUsuario, idFamilia, nome, preco, matricula) VALUES (?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idUsuario, $idFamilia, $nome, $preco, $matricula)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function updateCarro($idCarro, $idFamilia, $nome, $preco){
			$sql = "UPDATE carro SET idFamilia = ?, nome = ?, preco = ? WHERE idCarro = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idFamilia, $nome, $preco, $idCarro))){
				$stmt = null;
				header("location: ../carroLista.php?Erro=Editar!");
				exit();
			}
		}

		public function deleteCarro($idCarro){
			$sql = "DELETE FROM carro WHERE idCarro = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idCarro))){
				$stmt = null;
				header("location: ../carroLista.php?Erro=Eliminar!");
				exit();
			}
			$stmt = null;
		}
		
		public function dependentCar($idFamilia){
			$data = null;
			$sql = "SELECT * FROM carro WHERE idFamilia = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idFamilia]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function readCarro(){
			$sql = "SELECT * FROM carro";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){
				$row['idCarro'];
				$row['idUsuario'];
				$row['idFamilia'];
				$row['nome'];
				$row['preco'];
				$row['estado'];
			}
		}

		protected function dependentSelect($idFamilia){
			$sql = "SELECT * FROM carro WHERE idFamilia = ? ORDER BY carro.nome";
			$stmt = $this->connect()->prepare($sql);
			$stmt->execute([$idFamilia]);
			$results = $stmt->fetch();
			while($row = $stmt->fetch()){
				echo '<option name="idCarro" value="'.$row['idCarro'].'">' . $row['nome'] . '</option>';
			}
		}

		/*protected function deleteCarro($idCarro){
			$sql = "DELETE FROM carro WHERE idCarro = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!stmt->execute(array($idCarro))){
				$stmt = null;
				header("location: ../carroForm.php?Erro=Eliminar!");
				exit();
			}
			$stmt = null;
		}*/

		public function queyCarro($idFamilia){
			$data = null;
			$sql = "SELECT * FROM carro WHERE idFamilia = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idFamilia]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		protected function selectCarro(){
			$sql = "SELECT * FROM carro";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<option name="idCarro" value="'.$row['idCarro'].'">' . $row['nome'] . '</option>';//'<option value='"$row['idFamilia']"'>'"$row['nome']"'</option>';
				//echo $row['idUsuario'];
				//echo $row['nome'];
			}

		}


		protected function listaCarro(){
			$sql = "SELECT * FROM viewcarrofamiliamaisrecurso";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){
				if($row['estado'] == 0){
					$estado = "Inactivo";
				} else {
					$estado = "Activo";
				}
				echo '<tr>
					<td>'.$row['idCarro'].'</td>
					<td>'.$row['idFamilia'].'</td>
					<td>'.$row['nome'].'</td>
					<td>'.$row['preco'].'</td>
					<td>'.$estado.'</td>
					<td>'.$row['familia'].'</td>
					<td>
						<a class="user-info" data-id="'.$row['idCarro'].'" href="../includes/carroUpdate.inc.php?id='.$row['idCarro'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/carroDelete.inc.php?id='.$row['idCarro'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
					<td>'.$row['km'].'</td>
					<td>'.$row['tipo'].'</td>
					<td>'.$row['assento'].'</td>
					<td>'.$row['porta'].'</td>
					<td>'.$row['combustivel'].'</td>
					<td>'.$row['nBagagem'].'</td>
					<td>'.$row['descricaoMais'].'</td>
					<td>'.$row['ar'].'</td>
					<td>'.$row['assentoInfantil'].'</td>
					<td>'.$row['gps'].'</td>
					<td>'.$row['bagagem'].'</td>
					<td>'.$row['som'].'</td>
					<td>'.$row['cintoSeguranca'].'</td>
					<td>'.$row['cama'].'</td>
					<td>'.$row['agua'].'</td>
					<td>'.$row['bluetooth'].'</td>
					<td>'.$row['computadorBordo'].'</td>
					<td>'.$row['entradaAudio'].'</td>
					<td>'.$row['viagemLonga'].'</td>
					<td>'.$row['kitCarro'].'</td>
					<td>'.$row['travarRemoto'].'</td>
					<td>'.$row['controloClima'].'</td>
				</tr>';
			}

		}

	

		public function readFrota(){
			$sql = "SELECT * FROM carro ORDER BY ordem DESC";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){
				echo '<div class="col-md-4">
    				<div class="car-wrap rounded ftco-animate">
    					<div class="img rounded d-flex align-items-end" style="background-image: url(admin/images/galeria/'.$row['imagemNomeCompleto'].');">
    					</div>
    					<div class="text">
    						<h2 class="mb-0"><a href="car-single.html">'.$row['nome'].'</a></h2>
    						<div class="d-flex mb-3">
	    						<span class="cat">'.$row['descricao'].'</span>
	    						<p class="price ml-auto"> <span></span></p>
    						</div>
    						<p class="d-flex mb-0 d-block"><a href="#" class="btn btn-primary py-2 mr-1">Reservar agora</a> <a href="car-single.php?id='.$row['idCarro'].'" class="btn btn-secondary py-2 ml-1">Detalhes</a></p>
    					</div>
    				</div>
    			</div>';
			}
		}

		public function readFrotaOito(){
			$sql = "SELECT * FROM carro ORDER BY idCarro DESC LIMIT 8";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){
				echo '<div class="item">
    						<div class="car-wrap rounded ftco-animate">
		    					<div class="img rounded d-flex align-items-end" style="background-image: url(admin/images/galeria/'.$row['imagemNomeCompleto'].');">
		    					</div>
		    					<div class="text">
		    						<h2 class="mb-0"><a href="car-single.html">'.$row['nome'].'</a></h2>
		    						<div class="d-flex mb-3">
			    						<span class="cat">'.$row['descricao'].'</span>
			    						<!--p class="price ml-auto">$500 <span>/day</span></p-->
		    						</div>
		    						<p class="d-flex mb-0 d-block"><a href="#" class="btn btn-primary py-2 mr-1">Reservar agora</a> <a href="car-single.php?id='.$row['idCarro'].'" class="btn btn-secondary py-2 ml-1">Detalhes</a></p>
		    					</div>
		    				</div>
    					</div>';
			}
		}

		protected function countCarro(){
			$sql = "SELECT COUNT(*) FROM carro";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}

		public function detailCarro($idCarro){
			$sql = "SELECT * FROM viewcarrofamiliamaisrecurso WHERE idCarro = ?";
			$stmt = $this->connect()->prepare($sql);
			$stmt->execute([$idCarro]);
			$results = $stmt->fetchAll();
			foreach($results as $result){
				echo '<section class="ftco-section ftco-car-details">
      <div class="container">
      	<div class="row justify-content-center">
      		<div class="col-md-12">
      			<div class="car-details">
      				<div class="img rounded" style="background-image: url(admin/images/galeria/'.$result['imagemNomeCompleto'].');"></div>
      				<div class="text text-center">
      					<span class="subheading">'.$result['familia'].'</span>
      					<h2>'.$result['nome'].'</h2>
      					
      				</div>
      			</div>
      		</div>
      	</div>
      	<div class="row">
      		<div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon d-flex align-items-center justify-content-center"><span class="flaticon-dashboard"></span></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                	Quilometragem
		                	<span>'.$result['km'].'</span>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
          <div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon d-flex align-items-center justify-content-center"><span class="flaticon-pistons"></span></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                	Trasmissão
		                	<span>'.$result['tipo'].'</span>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
          <div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon d-flex align-items-center justify-content-center"><span class="flaticon-car-seat"></span></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                	Assentos
		                	<span>'.$result['assento'].' Adultos</span>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
          <div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon d-flex align-items-center justify-content-center"><span class="flaticon-backpack"></span></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                	Bagagem
		                	<span>'.$result['nBagagem'].' Malas</span>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
          <div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon d-flex align-items-center justify-content-center"><span class="flaticon-diesel"></span></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                	Combustível
		                	<span>'.$result['combustivel'].'</span>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
      	</div>
      	<div class="row">
      		<div class="col-md-12 pills">
						<div class="bd-example bd-example-tabs">
							<div class="d-flex justify-content-center">
							  <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">

							    <li class="nav-item">
							      <a class="nav-link active" id="pills-description-tab" data-toggle="pill" href="#pills-description" role="tab" aria-controls="pills-description" aria-expanded="true">Recursos</a>
							    </li>
							    <li class="nav-item">
							      <a class="nav-link" id="pills-manufacturer-tab" data-toggle="pill" href="#pills-manufacturer" role="tab" aria-controls="pills-manufacturer" aria-expanded="true">Descrição</a>
							    </li>
							    <li class="nav-item">
							      <a class="nav-link" id="pills-review-tab" data-toggle="pill" href="#pills-review" role="tab" aria-controls="pills-review" aria-expanded="true">Review</a>
							    </li>
							  </ul>
							</div>

						  <div class="tab-content" id="pills-tabContent">
						    <div class="tab-pane fade show active" id="pills-description" role="tabpanel" aria-labelledby="pills-description-tab">
						    	<div class="row">
						    		<div class="col-md-4">
						    			<ul class="features">
						    				<li><span class="rec"></span>Ar-condicionado</li>
						    				<li><span class="rec"></span>Assento Infantil</li>
						    				<li><span class="rec"></span>GPS</li>
						    				<li><span class="rec"></span>Bagagem</li>
						    				<li><span class="rec"></span>Música</li>
						    			</ul>
						    		</div>
						    		<div class="col-md-4">
						    			<ul class="features">
						    				<li><span class="rec"></span>Cinto de segurança</li>
						    				<li><span class="rec"></span>Cama</li>
						    				<li><span class="rec"></span>Água</li>
						    				<li><span class="rec"></span>Bluetooth</li>
						    				<li><span class="rec"></span>Computador de bordo</li>
						    			</ul>
						    		</div>
						    		<div class="col-md-4">
						    			<ul class="features">
						    				<li><span class="rec"></span>Entrada de áudio</li>
						    				<li><span class="rec"></span>Viagens de longa duração</li>
						    				<li><span class="rec"></span>Kit do carro</li>
						    				<li><span class="rec"></span>Fecho remoto central</li>
						    				<li><span class="rec"></span>Controle climático</li>
						    			</ul>
						    		</div>
						    	</div>
						    </div>

						    <div class="tab-pane fade" id="pills-manufacturer" role="tabpanel" aria-labelledby="pills-manufacturer-tab">
						      <p>'.$result['descricaoMais'].'.</p>
						    </div>

						    <div class="tab-pane fade" id="pills-review" role="tabpanel" aria-labelledby="pills-review-tab">
						      <div class="row">
							   		<div class="col-md-7">
							   			<h3 class="head">23 Reviews</h3>
							   			<div class="review d-flex">
									   		<div class="user-img" style="background-image: url(images/person_1.jpg)"></div>
									   		<div class="desc">
									   			<h4>
									   				<span class="text-left">Jacob Webb</span>
									   				<span class="text-right">14 March 2018</span>
									   			</h4>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
								   					</span>
								   					<span class="text-right"><a href="#" class="reply"><i class="icon-reply"></i></a></span>
									   			</p>
									   			<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrov</p>
									   		</div>
									   	</div>
									   	<div class="review d-flex">
									   		<div class="user-img" style="background-image: url(images/person_2.jpg)"></div>
									   		<div class="desc">
									   			<h4>
									   				<span class="text-left">Jacob Webb</span>
									   				<span class="text-right">14 March 2018</span>
									   			</h4>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
								   					</span>
								   					<span class="text-right"><a href="#" class="reply"><i class="icon-reply"></i></a></span>
									   			</p>
									   			<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrov</p>
									   		</div>
									   	</div>
									   	<div class="review d-flex">
									   		<div class="user-img" style="background-image: url(images/person_3.jpg)"></div>
									   		<div class="desc">
									   			<h4>
									   				<span class="text-left">Jacob Webb</span>
									   				<span class="text-right">14 March 2018</span>
									   			</h4>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
								   					</span>
								   					<span class="text-right"><a href="#" class="reply"><i class="icon-reply"></i></a></span>
									   			</p>
									   			<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrov</p>
									   		</div>
									   	</div>
							   		</div>
							   		<div class="col-md-5">
							   			<div class="rating-wrap">
								   			<h3 class="head">Give a Review</h3>
								   			<div class="wrap">
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(98%)
								   					</span>
								   					<span>20 Reviews</span>
									   			</p>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(85%)
								   					</span>
								   					<span>10 Reviews</span>
									   			</p>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(70%)
								   					</span>
								   					<span>5 Reviews</span>
									   			</p>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(10%)
								   					</span>
								   					<span>0 Reviews</span>
									   			</p>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(0%)
								   					</span>
								   					<span>0 Reviews</span>
									   			</p>
									   		</div>
								   		</div>
							   		</div>
							   	</div>
						    </div>
						  </div>
						</div>
		      </div>
				</div>
      </div>
    </section>
    <script type="text/javascript">
    	let rec = document.getElementsByClassName("rec");
    	let recurso = document.querySelector(".rec");
    	if('.$result['ar'].' == 0){
    		rec[0].parentNode.classList = "remove";
    			rec[0].classList += " ion-ios-close";

    		} else {
    			rec[0].parentNode.classList = "check";
    			rec[0].classList += " ion-ios-checkmark";
    		}

    		if('.$result['assentoInfantil'].' == 0){
    			rec[1].parentNode.classList = "remove";
    			rec[1].classList += " ion-ios-close";
    		} else {
    			rec[1].parentNode.classList = "check";
    			rec[1].classList += " ion-ios-checkmark";
    		}

    		if('.$result['gps'].' == 0){
    			rec[2].parentNode.classList = "remove";
    			rec[2].classList += " ion-ios-close";
    		} else {
    			rec[2].parentNode.classList = "check";
    			rec[2].classList += " ion-ios-checkmark";
    		}
    		if('.$result['bagagem'].' == 0){
    			rec[3].parentNode.classList = "remove";
    			rec[3].classList += " ion-ios-close";
    		} else {
    			rec[3].parentNode.classList = "check";
    			rec[3].classList += " ion-ios-checkmark";
    		}
    		if('.$result['som'].' == 0){
    			rec[4].parentNode.classList = "remove";
    			rec[4].classList += " ion-ios-close";
    		} else {
    			rec[4].parentNode.classList = "check";
    			rec[4].classList += " ion-ios-checkmark";
    		}
    		if('.$result['cintoSeguranca'].' == 0){
    			rec[5].parentNode.classList = "remove";
    			rec[5].classList += " ion-ios-close";
    		} else {
    			rec[5].parentNode.classList = "check";
    			rec[5].classList += " ion-ios-checkmark";
    		}
    		if('.$result['cama'].' == 0){
    			rec[6].parentNode.classList = "remove";
    			rec[6].classList += " ion-ios-close";
    		} else {
    			rec[6].parentNode.classList = "check";
    			rec[6].classList += " ion-ios-checkmark";
    		}
    		if('.$result['agua'].' == 0){
    			rec[7].parentNode.classList = "remove";
    			rec[7].classList += " ion-ios-close";
    		} else {
    			rec[7].parentNode.classList = "check";
    			rec[7].classList += " ion-ios-checkmark";
    		}
    		if('.$result['bluetooth'].' == 0){
    			rec[8].parentNode.classList = "remove";
    			rec[8].classList += " ion-ios-close";
    		} else {
    			rec[8].parentNode.classList = "check";
    			rec[8].classList += " ion-ios-checkmark";
    		}
    		if('.$result['computadorBordo'].' == 0){
    			rec[9].parentNode.classList = "remove";
    			rec[9].classList += " ion-ios-close";
    		} else {
    			rec[9].parentNode.classList = "check";
    			rec[9].classList += " ion-ios-checkmark";
    		}
    		if('.$result['entradaAudio'].' == 0){
    			rec[10].parentNode.classList = "remove";
    			rec[10].classList += " ion-ios-close";
    		} else {
    			rec[10].parentNode.classList = "check";
    			rec[10].classList += " ion-ios-checkmark";
    		}
    		if('.$result['viagemLonga'].' == 0){
    			rec[11].parentNode.classList = "remove";
    			rec[11].classList += " ion-ios-close";
    		} else {
    			rec[11].parentNode.classList = "check";
    			rec[11].classList += " ion-ios-checkmark";
    		}
    		if('.$result['kitCarro'].' == 0){
    			rec[12].parentNode.classList = "remove";
    			rec[12].classList += " ion-ios-close";
    		} else {
    			rec[12].parentNode.classList = "check";
    			rec[12].classList += " ion-ios-checkmark";
    		}
    		if('.$result['travarRemoto'].' == 0){
    			rec[13].parentNode.classList = "remove";
    			rec[13].classList += " ion-ios-close";
    		} else {
    			rec[13].parentNode.classList = "check";
    			rec[13].classList += " ion-ios-checkmark";
    		}
    		if('.$result['controloClima'].' == 0){
    			rec[14].parentNode.classList = "remove";
    			rec[14].classList += " ion-ios-close";
    		} else {
    			rec[14].parentNode.classList = "check";
    			rec[14].classList += " ion-ios-checkmark";
    		}
    </script>';
			}
		}


	}