<?php
    class DefinicaoModel extends Database {

		protected function insertPais($pais){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($pais, 4));
        }

		protected function insertSerie($serie){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($serie, 3));
        }

		protected function insertMoeda($moeda){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($moeda, 5));
        }

		protected function insertQtdLinhaPreco($qtdLinhaPreco){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($qtdLinhaPreco, 1));
        }

        protected function insertStockNegativo($stockNegativo){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($stockNegativo, 10));
        }

		protected function insertLinhaPrecoPredefinida($linhaPrecoPredefinida){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($linhaPrecoPredefinida, 2));
        }

		protected function insertTipoPrograma($tipoPrograma){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($tipoPrograma, 6));
        }

		protected function insertRetencaoFonte($retencaoFonte){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($retencaoFonte, 7));
        }

		protected function insertRegimeFiscal($regimeFiscal){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($regimeFiscal, 8));
        }

		protected function insertImpostoDeductivel($impostoDeductivel){
			$stmt = $this->connect();
			$sql = "UPDATE definicao SET valor = ? WHERE idDefinicao = ?";
			$query = $stmt->prepare($sql);
			$query->execute(array($impostoDeductivel, 9));
        }

        public function listagemDefinicao(){
			$data = null;
			$sql = "SELECT * FROM definicao";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}
    }