<?php
	class DocumentoController extends DocumentoModel {
		
		private $idUsuario;
		private $idTipoDoc;
		private $idEntidade;
		private $idPrazoPagamento;
		private $entregue;
		private $total;
		private $troco;
		private $totalLiquido;
		private $totalImposto;
		private $descontoGlobal;


		public function __construct($idUsuario, $idTipoDoc, $idEntidade, $idPrazoPagamento, $entregue, $total, $troco, $totalLiquido, $totalImposto, $descontoGlobal){
			$this->idUsuario = $idUsuario;
			$this->idTipoDoc = $idTipoDoc;
			$this->idEntidade = $idEntidade;
			$this->idPrazoPagamento = $idPrazoPagamento;
			$this->entregue = $entregue;
			$this->total = $total;
			$this->troco = $troco;
			$this->totalLiquido = $totalLiquido;
			$this->totalImposto = $totalImposto;
			$this->descontoGlobal = $descontoGlobal;
		}

		public function createDocumento(){
			try {
				if ($this->idTipoDoc == 33) {
					$dadosDoc = $this->verificarAdiantamento($this->idEntidade);
					if ($dadosDoc[0]['entregue'] != null) {
						try {
						 	$novoAdiantado = floatval($this->entregue) + floatval($dadosDoc[0]['entregue']);
						 	$this->updateAdiantado($dadosDoc[0]['idDocumento'], $novoAdiantado);
						 	return 'sucesso';
						} catch (Exception $e) {
							return 'Erro';
						}

					 } else {
						$result = $this->insertDocumento($this->idUsuario, $this->idTipoDoc, $this->idEntidade, $this->idPrazoPagamento, $this->entregue, $this->total, $this->troco, $this->totalLiquido, $this->totalImposto, $this->descontoGlobal);
						return $result;
					 }
				} else {
					$result = $this->insertDocumento($this->idUsuario, $this->idTipoDoc, $this->idEntidade, $this->idPrazoPagamento, $this->entregue, $this->total, $this->troco, $this->totalLiquido, $this->totalImposto, $this->descontoGlobal);
						return $result;
				}
				
				
				  
			} catch (Exception $e) {
				return "Catch";
			}
		}

		public function updateDocumento($idDocumento){
			$result = $this->editDocumento($idDocumento, $this->idUsuario, $this->idTipoDoc, $this->idEntidade, $this->idPrazoPagamento, $this->entregue, $this->total, $this->troco, $this->totalLiquido, $this->totalImposto, $this->descontoGlobal);
			return $result;
		}

		public function updateEntregue()
		{
			try {
				$dadosDoc = $this->verificarAdiantamento($this->idEntidade);
			 	$novoAdiantado = $this->entregue;
			 	$this->updateAdiantado($dadosDoc[0]['idDocumento'], $novoAdiantado);
			 	return 'sucesso';
			} catch (Exception $e) {
				return 'Erro';
			}
		}

		public function updateDocumentoFactura($idDocumento){
			$result = $this->editDocumentoFactura($idDocumento, $this->idUsuario, $this->idTipoDoc, $this->idEntidade, $this->idPrazoPagamento, $this->entregue, $this->total, $this->troco, $this->totalLiquido, $this->totalImposto, $this->descontoGlobal);
			return $result;
		}

		public function createDocumentoRelac($idDocumento, $idDocumentoRelac, $faltaDocRelac){
			$result = $this->insertDocumentoRelacao($idDocumento, $idDocumentoRelac, $faltaDocRelac, $this->idUsuario, $this->idTipoDoc, $this->idEntidade, $this->idPrazoPagamento, $this->entregue, $this->total, $this->troco, $this->totalLiquido, $this->totalImposto, $this->descontoGlobal);
			return $result;
		}

		public function createDocumentoStock(){
			$result = $this->insertDocumentoStock($this->idUsuario, $this->idTipoDoc, $this->idEntidade, $this->idPrazoPagamento, $this->entregue, $this->total, $this->troco, $this->totalLiquido, $this->totalImposto, $this->descontoGlobal);
			return $result;
		}
	}