<?php
	class FotoController extends FotoModel {
		private $id;

		private $ficheiro;
		private $nomeFicheiro;
		private $tipoFicheiro;
		private $nomeTemporarioFicheiro;
		private $erroFicheiro;
		private $tamanhoFicheiro;
		private $extensaoFicheiro;
		private $extensaoActualFicheiro;
		private $permitido;

		private $nomeCompletoImagem;
		private $destinoFicheiro;

		public function __construct($id, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido){
            $this->id = $id;

            $this->ficheiro = $ficheiro;
			$this->nomeFicheiro = $nomeFicheiro;
			$this->tipoFicheiro = $tipoFicheiro;
			$this->nomeTemporarioFicheiro = $nomeTemporarioFicheiro;
			$this->erroFicheiro = $erroFicheiro;
			$this->tamanhoFicheiro = $tamanhoFicheiro;
			$this->extensaoFicheiro = $extensaoFicheiro;
			$this->extensaoActualFicheiro = $extensaoActualFicheiro;
			$this->permitido = $permitido;
		}

		public function deleteUsuario($idUsuario){
			$this->eraseUsuario($idUsuario);
			$this->deleteImg($idUsuario);
		}

		public function deleteImg($idUsuario){
			$img = $this->fotoPerfil($idUsuario);
			$nameImg = "../../images/fotoPerfil/" . $img[0]["imagem"];
			$fileInfo = glob($nameImg);
			$fileExt = explode(".", $fileInfo[0]);
			$fileActualExt = $fileExt[5];
			print_r($nameImg);

        	$file = $nameImg;
			unlink($file);
		}

		public function updateUsuario($idUsuario){
			$this->checks();
			
			$this->deleteImg($idUsuario);
			$result = $this->editUsuario($idUsuario, $this->nome, $this->email, $this->dataNasc, $this->telefone, $this->endereco, $this->bi, $this->genero, $this->tipoUsuario, $this->periodo, $this->curso, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);

			return $result;
		}

		public function createFoto(){
            $this->checks();
			$result = $this->insertFoto($this->id, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			//$this->insertTurmaAluno($result, $this->periodo, $this->curso);
			//$turmaAluno = $this->verifySetTurma($result);
			return $result;
		}

		public function createFotoEntidade(){
			$this->checksEntidade();
			$result = $this->insertFotoEntidade($this->id, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}

		public function createFotoArtigo(){
			$this->checksArtigo();
			$result = $this->insertFotoArtigo($this->id, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}

		public function createFotoMilitar(){
			$this->checksMilitar();
			$result = $this->insertFotoMilitar($this->id, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}

		public function createFotoParceiro(){
			$this->checksParceiro();
			$result = $this->insertFotoParceiro($this->id, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}

		public function createFotoUsuario(){
			$this->checksUsuario();
			$result = $this->insertFotoUsuario($this->id, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}

		public function createFotoModoPagamento(){
			$this->checksModoPagamento();
			$result = $this->insertFotoModoPagamento($this->id, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}

		public function uploadFotoMatriculaFrontal(){
			$this->checksFotoMatriculaFrontal();
			$result = $this->insertFotoFrontal($this->id, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}

		public function uploadFotoMatriculaTraseira(){
			$this->checksFotoMatriculaTraseira();
			$result = $this->insertFotoTraseira($this->id, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}

		public function verifySetTurma($result){
			if($result[0]["idTipoUsuario"] == 2){
				$turma = $this->readTurma();
				for($i = 0; $i < count($turma); $i++){
					$turmaAluno = "";
					if($turma[$i]["capacidade"] != 0){
						$turmaAluno = $this->setTurmaAluno($turma[$i]["idTurma"], $result[0]["idUsuario"]);
						$this->updateTurma($turma[$i]["idTurma"], $turma[$i]["capacidade"]);
						break;
					}
				}
			}
			return $turmaAluno;
		}

		public function updateTurma($idTurma, $capacidade){
			$decremento = $capacidade - 1;
			$result = $this->editTurma($idTurma, $decremento);
			return $result;
		}

		public function setTurmaAluno($idTurma, $idAluno){
			$result = $this->insertTurmaAluno($idTurma, $idAluno);
			return $result;
		}


		public function checks(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = strtolower(str_replace(" ", "-", $this->nome)) . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/fotoPerfil/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function checksArtigo(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = "artigo" . "_" . $this->id . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/artigo/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function checksMilitar(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = "militar" . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/militar/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function checksEntidade(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = "entidade" . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/entidade/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function checksUsuario(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = "usuario" . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/usuario/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function checksModoPagamento(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = "modoPagamento" . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/modoPagamento/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function checksParceiro(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = "parceiro" . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/parceiro/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function checksFotoMatriculaFrontal(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = "fotoFrontal" . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/matricula/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function checksFotoMatriculaTraseira(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = "fotoTraseira" . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../../images/matricula/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function setPeriodoCurso(int $idUsuario, int $periodo, int $curso){
			$this->idUsuario = $idUsuario;
			$this->periodo = $periodo;
			$this->curso = $curso;
			$result = $this->insertPeriodoCurso($this->$idUsuario, $this->periodo, $this->curso);
			return $result;
		}

	}