<?php

	class GaleriaController extends GaleriaModel {

		private $novoNomeFicheiro;
		private $tituloImagem;
		private $descricaoImagem;
		private $ficheiro;
		private $nomeFicheiro;
		private $tipoFicheiro;
		private $nomeTemporarioFicheiro;
		private $erroFicheiro;
		private $tamanhoFicheiro;
		private $extensaoFicheiro;
		private $extensaoActualFicheiro;
		private $permitido;

		private $nomeCompletoImagem;
		private $destinoFicheiro;

		public function __construct($novoNomeFicheiro, $tituloImagem, $descricaoImagem, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido){
			$this->novoNomeFicheiro = $novoNomeFicheiro;
			$this->tituloImagem = $tituloImagem;
			$this->descricaoImagem = $descricaoImagem;
			$this->ficheiro = $ficheiro;
			$this->nomeFicheiro = $nomeFicheiro;
			$this->tipoFicheiro = $tipoFicheiro;
			$this->nomeTemporarioFicheiro = $nomeTemporarioFicheiro;
			$this->erroFicheiro = $erroFicheiro;
			$this->tamanhoFicheiro = $tamanhoFicheiro;
			$this->extensaoFicheiro = $extensaoFicheiro;
			$this->extensaoActualFicheiro = $extensaoActualFicheiro;
			$this->permitido = $permitido;
		}

		public function uploadImage(){
			if($this->emptyEntry() == false){
				header("location: ../galeria.php?Erro=NomeFicheiroVazio!");
				exit();
			}
			if($this->emptyInput() == false){
				header("location: ../index.php?UploadImagem=Vazio!");
				exit();
			} else {
				$this->checks();
				$this->insertImage($this->novoNomeFicheiro, $this->tituloImagem, $this->descricaoImagem, $this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			}
		}

		public function emptyEntry(){
			if(empty($this->novoNomeFicheiro)){
				$this->novoNomeFicheiro = "galeria";
				$result = false;
			} else {
				$this->novoNomeFicheiro = strtolower(str_replace(" ", "-", $this->novoNomeFicheiro));
				$result = true;
			}
			return $result;
		}

		public function emptyInput(){
			if(empty($this->tituloImagem) || empty($this->descricaoImagem)){
				$result = false;
			} else {
				$result = true;
			}
			return $result;
		}

		public function checks(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = $this->novoNomeFicheiro . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../images/galeria/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				exit();
			}
		}
	}