<?php
    class GrupoUsuarioModel extends Database {

		protected function insertGrupoUsuario($nome, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO grupoUsuario (nome, nota) VALUES (?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nome, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemGrupoUsuario(){
			$data = null;
			$sql = "SELECT * FROM grupoUsuario";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryGrupoUsuario($idGrupoUsuario){
			$data = null;
			$sql = "SELECT * FROM grupoUsuario WHERE idGrupoUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idGrupoUsuario]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editGrupoUsuario($idGrupoUsuario, $nome, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE grupoUsuario SET nome = ?, nota = ? WHERE idGrupoUsuario = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $nota, $idGrupoUsuario)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteGrupoUsuario($idGrupoUsuario){
			$stmt = $this->connect();
            $sql = "DELETE FROM grupoUsuario WHERE idGrupoUsuario = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idGrupoUsuario)))){
				$query = null;
				exit();
			}
		}

		public function autoIncrementGrupoUsuario()
		{
			$sql = "SELECT `AUTO_INCREMENT`
				FROM INFORMATION_SCHEMA.TABLES
				WHERE TABLE_SCHEMA = 'test1234'
				AND TABLE_NAME = 'grupoUsuario';";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			return $results['AUTO_INCREMENT'];
		}
    }