<?php

class LoteModel extends Database {

	protected function insertLote($idUsuario, $descricao, $tipoMovimento, $sugestaoMovimento, $movExp, $dataExp, $dataProd){
		$stmt = $this->connect();
		$sql = "INSERT INTO lote (idUsuario, descricao, tipoMovimento, sugestaoMovimento, movExp, dataExp, dataProd) VALUES (?, ?, ?, ?, ?, ?, ?)";
		$query = $stmt->prepare($sql);
		if(!($query->execute(array($idUsuario, $descricao, $tipoMovimento, $sugestaoMovimento, $movExp, $dataExp, $dataProd)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

		protected function editLote($idLote, $idUsuario, $descricao, $tipoMovimento, $sugestaoMovimento, $movExp, $dataExp, $dataProd){
			$sql = "UPDATE lote SET idUsuario = ?, descricao = ?, tipoMovimento = ?, sugestaoMovimento = ?, movExp = ?, dataExp = ?, dataProd = ? WHERE idLote = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idUsuario, $descricao, $tipoMovimento, $sugestaoMovimento, $movExp, $dataExp, $dataProd, $idLote))){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}
		
		public function parentLote(){
			$data = null;
			$sql = "SELECT * FROM lote";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function readCodigoLote(){
			$data = null;
			$sql = "SELECT COALESCE(MAX(idLote), 0) + 1 AS contador FROM lote";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryLote($idLote){
			$data = null;
			$sql = "SELECT * FROM lote WHERE idLote = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idLote]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemLote(){
			$data = null;
			$sql = "SELECT * FROM lote";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteLote($idLote){
			$sql = "DELETE FROM lote WHERE idLote = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute([$idLote])){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}

		protected function selectLote(){
			$sql = "SELECT * FROM lote";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<option name="idLote" value="'.$row['idLote'].'">' . $row['descricao'] . '</option>';//'<option value='"$row['idLote']"'>'"$row['descricao']"'</option>';
				//echo $row['idUsuario'];
				//echo $row['descricao'];
			}

		}

		protected function listaLote(){
			$sql = "SELECT * FROM lote";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idLote'].'</td>
					<td>'.$row['descricao'].'</td>
					<td>
						<a href="../includes/LoteUpdate.inc.php?id='.$row['idLote'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/LoteDelete.inc.php?id='.$row['idLote'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}

		protected function countLote(){
			$sql = "SELECT COUNT(*) FROM lote";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}

		public function autoIncrementLote()
	{
		$sql = "SELECT `AUTO_INCREMENT`
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'lote';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['AUTO_INCREMENT'];
	}
	}