<?php

class Model extends Database
{

	protected function insert($tabela, $dados)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO ";
		$sql .= $tabela . " (";
		$campo = array_keys($dados);
		$valor = array_values($dados);
		for($i = 0; $i < count($campo); $i++){
			$sql .= $campo[$i];
			if($i < count($campo) - 1){
				$sql .= " ,";
			}
		}
		$sql .= ") VALUES (";
		for($i = 0; $i < count($valor); $i++){
			$sql .= "?";
			if($i < count($valor) - 1){
				$sql .= ", ";
			}
			$valor[$i] = $valor[$i] != '' ? $valor[$i] : null;
		}
		$sql .= ")";
		$query = $stmt->prepare($sql);
		if (!($query->execute($valor))) {
			echo "Erro SQL: " . implode(", ", $query->errorInfo());
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function update($tabela, $dados, $id)
	{
		$stmt = $this->connect();
		$sql = "UPDATE " . $tabela . " SET ";
		$idCampo = array_keys($id);
		$idValor = array_values($id);
		$campo = array_keys($dados);
		$valor = array_values($dados);
		for($i = 0; $i < count($campo); $i++){
			$sql .= $campo[$i] . " = " . "?";
			if($i < count($campo) - 1){
				$sql .= ", ";
			}
		}
		$sql .= " WHERE ";
		for($i = 0; $i < count($idCampo); $i++){
			$sql .= $idCampo[$i] . " = " . "?";
		}
		$query = $stmt->prepare($sql);
		$parametro = array_merge($valor, $idValor);
		if (!($query->execute($parametro))) {
			echo "Erro SQL: " . implode(", ", $query->errorInfo());
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $sql;
	}

	protected function delete($tabela, $dados, $id)
	{
		$stmt = $this->connect();
		$sql = "DELETE FROM " . $tabela . " WHERE ";
		$idCampo = array_keys($id);
		$idValor = array_values($id);
		for($i = 0; $i < count($idCampo); $i++){
			$sql .= $idCampo[$i] . " = " . "?";
		}
		$query = $stmt->prepare($sql);
		if (!($query->execute($idValor))) {
			echo "Erro SQL: " . implode(", ", $query->errorInfo());
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $sql;
	}

	public function parentArmazem()
	{
		$data = null;
		$sql = "SELECT * FROM armazem";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readCodigoArmazem()
	{
		$data = null;
		$sql = "SELECT COALESCE(MAX(idArmazem), 0) + 1 AS contador FROM armazem";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryArmazem($idArmazem)
	{
		$data = null;
		$sql = "SELECT * FROM armazem WHERE idArmazem = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArmazem]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemArmazem()
	{
		$data = null;
		$sql = "SELECT * FROM armazem";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function deleteArmazem($idArmazem)
	{
		$sql = "DELETE FROM armazem WHERE idArmazem = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute([$idArmazem])) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	protected function selectArmazem()
	{
		$sql = "SELECT * FROM armazem";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<option name="idArmazem" value="' . $row['idArmazem'] . '">' . $row['nome'] . '</option>'; //'<option value='"$row['idArmazem']"'>'"$row['nome']"'</option>';
			//echo $row['idUsuario'];
			//echo $row['nome'];
		}
	}

	protected function listaArmazem()
	{
		$sql = "SELECT * FROM armazem";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<tr>
					<td>' . $row['idArmazem'] . '</td>
					<td>' . $row['nome'] . '</td>
					<td>
						<a href="../includes/ArmazemUpdate.inc.php?id=' . $row['idArmazem'] . '" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/ArmazemDelete.inc.php?id=' . $row['idArmazem'] . '"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
		}
	}

	public function autoIncrementArmazem()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'armazem';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}

	protected function countArmazem()
	{
		$sql = "SELECT COUNT(*) FROM armazem";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		echo $results['COUNT(*)'];
	}
}
