<?php
    class ModoPagamentoVendaModel extends Database {

		protected function insertModoPagamentoVenda($idVenda, $idModoPagamento, $valor){
            $stmt = $this->connect();
            $sql = "INSERT INTO modoPagamentoVenda (idVenda, idModoPagamento, valor) VALUES (?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idVenda, $idModoPagamento, $valor)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemModoPagamento(){
			$data = null;
			$sql = "SELECT * FROM modoPagamento";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryModoPagamento($idModoPagamento){
			$data = null;
			$sql = "SELECT * FROM modoPagamento WHERE idModoPagamento = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idModoPagamento]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editModoPagamento($idModoPagamento, $nome, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE modoPagamento SET nome = ?, nota = ? WHERE idModoPagamento = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $nota, $idModoPagamento)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteModoPagamento($idModoPagamento){
			$stmt = $this->connect();
            $sql = "DELETE FROM modoPagamento WHERE idModoPagamento = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idModoPagamento)))){
				$query = null;
				exit();
			}
		}
    }