<?php
    class MoedaModel extends Database {

		protected function insertMoeda($codigo, $nome, $simbolo, $posicao, $casaDecimal){
            $stmt = $this->connect();
            $sql = "INSERT INTO moeda (codigo, nome, simbolo, posicao, casaDecimal) VALUES (?, ?, ? , ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($codigo, $nome, $simbolo, $posicao, $casaDecimal)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemMoeda(){
			$data = null;
			$sql = "SELECT * FROM moeda";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryMoeda($idMoeda){
			$data = null;
			$sql = "SELECT * FROM moeda WHERE idMoeda = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idMoeda]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editMoeda($idMoeda, $codigo, $nome, $simbolo, $posicao, $casaDecimal){
			$stmt = $this->connect();
			
            $sql = "UPDATE moeda SET codigo = ?, nome = ?, simbolo = ?, posicao = ?, casaDecimal = ? WHERE idMoeda = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($codigo, $nome, $simbolo, $posicao, $casaDecimal, $idMoeda)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteMoeda($idMoeda){
			$stmt = $this->connect();
            $sql = "DELETE FROM moeda WHERE idMoeda = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idMoeda)))){
				$query = null;
				exit();
			}
		}
    }