<?php
    class PermissaoModel extends Database {

		protected function insertPermissao($create, $read, $update, $delete){
            $stmt = $this->connect();
            $sql = "INSERT INTO permissao (create, read, update, delete) VALUES (?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($create, $read, $update, $delete)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemPermissao(){
			$data = null;
			$sql = "SELECT * FROM permissao";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryPermissao($idPermissao){
			$data = null;
			$sql = "SELECT * FROM permissao WHERE idPermissao = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idPermissao]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editPermissao($idPermissao, $nome, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE permissao SET nome = ?, nota = ? WHERE idPermissao = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $nota, $idPermissao)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deletePermissao($idPermissao){
			$stmt = $this->connect();
            $sql = "DELETE FROM permissao WHERE idPermissao = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idPermissao)))){
				$query = null;
				exit();
			}
		}
    }