<?php

class RecursoModel extends Database {

		protected function insertRecurso($idCarro, $ar, $assentoInfantil, $gps, $bagagem, $som, $triangulo, $extintor, $macaco, $chaves, $luvas, $lanterna, $documentos){
			$sql = "INSERT INTO recurso (idCarro, ar, assentoInfantil, gps, bagagem, som, triangulo, extintor, macaco, chaves, luvas, lanterna, documentos) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idCarro, $ar, $assentoInfantil, $gps, $bagagem, $som, $triangulo, $extintor, $macaco, $chaves, $luvas, $lanterna, $documentos))){
				$stmt = null;
				header("location: ../carroForm.php?Erro=Inserir!");
				exit();
			}
			$stmt = null;
		}

		public function deleteRecurso($idRecurso){
			$sql = "DELETE FROM recurso WHERE idRecurso = ?";
			$stmt = $this->connect()->prepare($sql);
			$stmt->execute([$idRecurso]);
		}

		protected function readRecurso(){
			$sql = "SELECT * FROM recurso";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){
				$row['idRecurso'];
				$row['idUsuario'];
				$row['idCarro'];
				$row['ar'];
				$row['assentoInfantil'];
				$row['gps'];
				$row['bagagem'];
				$row['som'];
				$row['cintoSeguranca'];
				$row['cama'];
				$row['agua'];
				$row['bluetooth'];
				$row['computadorBordo'];
				$row['entradaAudio'];
				$row['viagemLonga'];
				$row['kitCarro'];
				$row['travarRemoto'];
				$row['controloClima'];
			}
		}

		protected function updateRecurso($idRecurso, $idCarro, $ar, $assentoInfantil, $gps, $bagagem, $som, $triangulo, $extintor, $macaco, $chaves, $luvas, $lanterna, $documentos){
			$sql = "UPDATE recurso SET idCarro = ?, ar = ?, assentoInfantil = ?, gps = ?, bagagem = ?, som = ?, triangulo = ?, extintor = ?, macaco = ?, chaves = ?, luvas = ?, lanterna = ?, documentos = ? WHERE idRecurso = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idCarro, $ar, $assentoInfantil, $gps, $bagagem, $som, $triangulo, $extintor, $macaco, $chaves, $luvas, $lanterna, $documentos, $idRecurso))){
				$stmt = null;
				header("location: ../carroForm.php?Erro=Editar!");
				exit();
			}
			$stmt = null;
		}

		/*protected function deleteRecurso($idRecurso){
			$sql = "DELETE FROM recurso WHERE idRecurso = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!stmt->execute(array($idRecurso))){
				$stmt = null;
				header("location: ../carroForm.php?Erro=Eliminar!");
				exit();
			}
			$stmt = null;
		}*/

		protected function listaRecurso(){
			$sql = "SELECT * FROM viewRecursoCarro";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idRecurso'].'</td>
					<td>'.$row['ar'].'</td>
					<td>'.$row['assentoInfantil'].'</td>
					<td>'.$row['gps'].'</td>
					<td>'.$row['bagagem'].'</td>
					<td>'.$row['som'].'</td>
					<td>'.$row['cintoSeguranca'].'</td>
					<td>'.$row['cama'].'</td>
					<td>'.$row['agua'].'</td>
					<td>'.$row['bluetooth'].'</td>
					<td>'.$row['computadorBordo'].'</td>
					<td>'.$row['entradaAudio'].'</td>
					<td>'.$row['viagemLonga'].'</td>
					<td>'.$row['kitCarro'].'</td>
					<td>'.$row['travarRemoto'].'</td>
					<td>'.$row['controloClima'].'</td>
					<td>'.$row['idCarro'].'</td>
					<td>'.$row['nomeCarro'].'</td>
					<td>'.$row['carroEstado'].'</td>
					<td>
						<a href="../includes/recursoUpdate.inc.php?'.$row['idRecurso'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../admin/includes/recursoDelete.inc.php?'.$row['idRecurso'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}
	}