<?php

class RegiaoModel extends Database {

	protected function insertRegiao($idPais, $codigo, $designacao){
		$stmt = $this->connect();
		$sql = "INSERT INTO regiao (idPais, codigo, designacao) VALUES (?, ?, ?)";
		$query = $stmt->prepare($sql);
		if(!($query->execute(array($idPais, $codigo, $designacao)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

		protected function editRegiao($idRegiao, $idPais, $codigo, $designacao){
			$sql = "UPDATE regiao SET idPais = ?, codigo = ?, designacao = ? WHERE idRegiao = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idPais, $codigo, $designacao, $idRegiao))){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}
		
		public function parentRegiao(){
			$data = null;
			$sql = "SELECT * FROM regiao";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function readCodigoRegiao(){
			$data = null;
			$sql = "SELECT COALESCE(MAX(idRegiao), 0) + 1 AS contador FROM regiao";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryRegiao($idRegiao){
			$data = null;
			$sql = "SELECT * FROM viewregiaopais WHERE idRegiao = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idRegiao]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemRegiao(){
			$data = null;
			$sql = "SELECT * FROM viewregiaopais";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteRegiao($idRegiao){
			$sql = "DELETE FROM regiao WHERE idRegiao = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute([$idRegiao])){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}

		protected function funcaoReadRegiao(){
			$sql = "SELECT * FROM regiao";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<option name="idRegiao" value="'.$row['idRegiao'].'">' . $row['nome'] . '</option>';//'<option value='"$row['idRegiao']"'>'"$row['nome']"'</option>';
				//echo $row['idUsuario'];
				//echo $row['nome'];
			}

		}

		protected function listaRegiao(){
			$sql = "SELECT * FROM regiao";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idRegiao'].'</td>
					<td>'.$row['nome'].'</td>
					<td>
						<a href="../includes/RegiaoUpdate.inc.php?id='.$row['idRegiao'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/RegiaoDelete.inc.php?id='.$row['idRegiao'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}

		protected function countRegiao(){
			$sql = "SELECT COUNT(*) FROM regiao";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}
	}