<?php
class RelatorioModel extends Database
{

	public function FuncaoRelatorio($tabela, $dados){
		$data = null;

		$campo = array_keys($dados);
		$valor = array_values($dados);

		$sql = "SELECT * FROM $tabela WHERE ";

		for($i = 0; $i < count($campo); $i++){
			$sql .= $campo[$i];
				
			if(count($valor[$i]) > 1){
				$sql .= " BETWEEN ";
			} else {
				$sql .= " = ";
			}

			for($j = 0; $j < count($valor[$i]); $j++){
				$sql .= $valor[$i][$j];

				if($j < count($valor[$i]) - 1){
					$sql .= " AND ";
				}
			}

			if($i < count($campo) - 1){
				$sql .= " AND ";
			}
		}

		if($stmt = $this->connect()->query($sql)){
			while($row = $stmt->fetch()){
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryVendaDocumentoEmitido($tabela, $parametros)
	{
		$data = null;
		$sql = "SELECT * FROM $tabela";
		$sql .= " WHERE ";
		$value = [];
		$parameter = [];
		for ($i = 0; $i < count($parametros); $i++) {
			if (is_array($parametros[$i]["Valor"])) {
				if ($parametros[$i]["Funcao"] != null) {
					if ($parametros[$i]["Valor"][0] != null && $parametros[$i]["Valor"][1] != null) {
						$parameter[] = "(" . $parametros[$i]["Funcao"] . "(" . $parametros[$i]["Campo"] . ")" . " BETWEEN " . "'" . $parametros[$i]["Valor"][0] . "'" . " AND " . "'" . $parametros[$i]["Valor"][1] . "'" . ")";
					}
				} else {
					if ($parametros[$i]["Valor"][0] != null && $parametros[$i]["Valor"][1] != null) {
						$parameter[] = "(" . $parametros[$i]["Campo"] . " BETWEEN " . "'" . $parametros[$i]["Valor"][0] . "'" . " AND " . "'" . $parametros[$i]["Valor"][1] . "'" . ")";
					}
				}
			} else if ($parametros[$i]["Valor"] != null) {
				if ($parametros[$i]["Funcao"] != null) {
					$parameter[] = $parametros[$i]["Funcao"] . "(" . $parametros[$i]["Campo"] . ")" . " = " . "'" . $parametros[$i]["Valor"] . "'";
				} else {
					$parameter[] = $parametros[$i]["Campo"] . " = " . "'" . $parametros[$i]["Valor"] . "'";
				}
				$dataString = implode(" AND ", $parameter);
				$value[] = $parametros[$i]["Valor"];
			}

		}
		$sql .= $dataString;

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute($value);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryVendaTotalMensal($tipoDocumento, $imposto, $totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal)
	{
		$data = null;
		$sql = "SELECT *, YEAR(datadoc) AS ano, MONTH(datadoc) AS mes, SUM(qtd) AS qtd, SUM(desconto) AS desconto, SUM(d.entregue) AS totalEntregue, SUM(d.total) AS totalAbsoluto, SUM(troco) AS totalTroco,";

		if ($imposto == "0") {
			$sql .= " (SUM(a.precoCustoSemImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoSemImp) * qtd) AS lucro";
		} else if ($imposto == "1") {
			$sql .= " (SUM(a.precoCustoComImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoComImp) * qtd) AS lucro";
		}

		$sql .= " FROM artigodocumento ad INNER JOIN artigo a ON (ad.idArtigo = a.idArtigo) INNER JOIN documento d ON (ad.idDocumento = d.idDocumento) INNER JOIN tipoDoc td ON (d.idTipoDoc = td.idTipoDoc)";

		if (stripos($sql, "WHERE") == false) {
			if ($dataInicial != null || $dataFinal != null || $ano != null) {
				$sql .= " WHERE";
			}
		}

		if ($totais == "anuais") {
			if ($ano != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $ano . "'";
			}
		} else if ($totais == "entreDatas") {
			if ($dataInicial != null && $dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) BETWEEN " . "'" . $dataInicial . "'" . " AND " . "'" . $dataFinal . "'" . ")";
			} else if ($dataInicial != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataInicial . "'" . ")";
			} else if ($dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataFinal . "'" . ")";
			}
		}

		if (stripos($sql, "WHERE") == false) {
			$sql .= " WHERE";
			$sql .= " tipoDocumento = " . "'" . $tipoDocumento . "'";
		} else {
			$sql .= " AND " . " tipoDocumento = " . "'" . $tipoDocumento . "'";
		}

		$sql .= " GROUP BY mes ORDER BY mes";

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$imposto, $totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryVendaTotalDia($imposto, $totais, $anoMes, $mes, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal)
	{
		$data = null;
		$sql = "SELECT DATE(datadoc) AS dataDocumento, DAY(datadoc) AS dia, SUM(qtd) AS qtd, SUM(desconto) AS desconto, SUM(d.entregue) AS totalEntregue, SUM(d.total) AS totalAbsoluto, SUM(troco) AS totalTroco,";

		if ($imposto == "0") {
			$sql .= " (SUM(a.precoCustoSemImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoSemImp) * qtd) AS lucro";
		} else if ($imposto == "1") {
			$sql .= " (SUM(a.precoCustoComImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoComImp) * qtd) AS lucro";
		}

		$sql .= " FROM artigodocumento ad INNER JOIN artigo a ON (ad.idArtigo = a.idArtigo) INNER JOIN documento d ON (ad.idDocumento = d.idDocumento)";

		if (stripos($sql, "WHERE") == false) {
			if ($dataInicial != null || $dataFinal != null || $ano != null || $anoMes != null) {
				$sql .= " WHERE";
			}
		}

		if ($totais == "mensais") {
			if ($anoMes != null && $mes != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $anoMes . "'" . " AND MONTH(datadoc) = " . "'" . $mes . "'";
			}
		} else if ($totais == "anuais") {
			if ($ano != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $ano . "'";
			}
		} else if ($totais == "entreDatas") {
			if ($dataInicial != null && $dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) BETWEEN " . "'" . $dataInicial . "'" . " AND " . "'" . $dataFinal . "'" . ")";
			} else if ($dataInicial != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataInicial . "'" . ")";
			} else if ($dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataFinal . "'" . ")";
			}
		}

		$sql .= " GROUP BY dia ORDER BY datadoc";

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$imposto, $totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryVendaTotalFamilia($imposto, $totais, $anoMes, $mes, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal)
	{
		$data = null;
		$sql = "SELECT f.idFamilia as refFamilia, f.nome as familia, DATE(datadoc) AS dataDocumento, DAY(datadoc) AS dia, SUM(qtd) AS qtd, SUM(desconto) AS desconto, SUM(d.entregue) AS totalEntregue, SUM(d.total) AS totalAbsoluto, SUM(troco) AS totalTroco,";

		if ($imposto == "0") {
			$sql .= " (SUM(a.precoCustoSemImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoSemImp) * qtd) AS lucro";
		} else if ($imposto == "1") {
			$sql .= " (SUM(a.precoCustoComImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoComImp) * qtd) AS lucro";
		}

		$sql .= " FROM artigodocumento ad INNER JOIN artigo a ON (ad.idArtigo = a.idArtigo) INNER JOIN documento d ON (ad.idDocumento = d.idDocumento) INNER JOIN familia f ON (a.idFamilia = f.idFamilia)";

		if (stripos($sql, "WHERE") == false) {
			if ($dataInicial != null || $dataFinal != null || $ano != null || $anoMes != null) {
				$sql .= " WHERE";
			}
		}

		if ($totais == "mensais") {
			if ($anoMes != null && $mes != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $anoMes . "'" . " AND MONTH(datadoc) = " . "'" . $mes . "'";
			}
		} else if ($totais == "anuais") {
			if ($ano != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $ano . "'";
			}
		} else if ($totais == "entreDatas") {
			if ($dataInicial != null && $dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) BETWEEN " . "'" . $dataInicial . "'" . " AND " . "'" . $dataFinal . "'" . ")";
			} else if ($dataInicial != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataInicial . "'" . ")";
			} else if ($dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataFinal . "'" . ")";
			}
		}

		$sql .= " GROUP BY refFamilia ORDER BY datadoc";

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$imposto, $totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryVendaTotalArtigo($imposto, $totais, $anoMes, $mes, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal)
	{
		$data = null;
		$sql = "SELECT a.idArtigo as refArtigo, a.nome as artigo, DATE(datadoc) AS dataDocumento, DAY(datadoc) AS dia, SUM(qtd) AS qtd, SUM(desconto) AS desconto, SUM(d.entregue) AS totalEntregue, SUM(d.total) AS totalAbsoluto, SUM(troco) AS totalTroco,";

		if ($imposto == "0") {
			$sql .= " (SUM(a.precoCustoSemImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoSemImp) * qtd) AS lucro";
		} else if ($imposto == "1") {
			$sql .= " (SUM(a.precoCustoComImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoComImp) * qtd) AS lucro";
		}

		$sql .= " FROM artigodocumento ad INNER JOIN artigo a ON (ad.idArtigo = a.idArtigo) INNER JOIN documento d ON (ad.idDocumento = d.idDocumento)";

		if (stripos($sql, "WHERE") == false) {
			if ($dataInicial != null || $dataFinal != null || $ano != null || $anoMes != null) {
				$sql .= " WHERE";
			}
		}

		if ($totais == "mensais") {
			if ($anoMes != null && $mes != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $anoMes . "'" . " AND MONTH(datadoc) = " . "'" . $mes . "'";
			}
		} else if ($totais == "anuais") {
			if ($ano != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $ano . "'";
			}
		} else if ($totais == "entreDatas") {
			if ($dataInicial != null && $dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) BETWEEN " . "'" . $dataInicial . "'" . " AND " . "'" . $dataFinal . "'" . ")";
			} else if ($dataInicial != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataInicial . "'" . ")";
			} else if ($dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataFinal . "'" . ")";
			}
		}

		$sql .= " GROUP BY refArtigo ORDER BY datadoc";

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$imposto, $totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryVendaTotalTipoPagamento($totais, $anoMes, $mes, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal)
	{
		$data = null;
		$sql = "SELECT mp.idModoPagamento as refModoPagamento, mp.nome as modoPagamento, SUM(mpd.valor) AS total FROM artigodocumento ad INNER JOIN artigo a ON (ad.idArtigo = a.idArtigo) INNER JOIN documento d ON 
		(ad.idDocumento = d.idDocumento) inner join modopagamentodocumento mpd on (d.idDocumento = mpd.idDocumento) inner join modopagamento mp on 
		(mpd.idModoPagamento = mp.idModoPagamento)";

		if (stripos($sql, "WHERE") == false) {
			if ($dataInicial != null || $dataFinal != null || $ano != null || $anoMes != null) {
				$sql .= " WHERE";
			}
		}

		if ($totais == "mensais") {
			if ($anoMes != null && $mes != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $anoMes . "'" . " AND MONTH(datadoc) = " . "'" . $mes . "'";
			}
		} else if ($totais == "anuais") {
			if ($ano != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $ano . "'";
			}
		} else if ($totais == "entreDatas") {
			if ($dataInicial != null && $dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) BETWEEN " . "'" . $dataInicial . "'" . " AND " . "'" . $dataFinal . "'" . ")";
			} else if ($dataInicial != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataInicial . "'" . ")";
			} else if ($dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataFinal . "'" . ")";
			}
		}

		$sql .= " GROUP BY refModoPagamento ORDER BY mp.idModoPagamento";

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryVendaTotalVendedor($imposto, $totais, $anoMes, $mes, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal)
	{
		$data = null;
		$sql = "SELECT u.idUsuario as refUsuario, u.nome as usuario, DATE(datadoc) AS dataDocumento, DAY(datadoc) AS dia, SUM(qtd) AS qtd, SUM(desconto) AS desconto, SUM(d.entregue) AS totalEntregue, SUM(d.total) AS totalAbsoluto, SUM(troco) AS totalTroco,";

		if ($imposto == "0") {
			$sql .= " (SUM(a.precoCustoSemImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoSemImp) * qtd) AS lucro";
		} else if ($imposto == "1") {
			$sql .= " (SUM(a.precoCustoComImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoComImp) * qtd) AS lucro";
		}

		$sql .= " FROM artigodocumento ad INNER JOIN artigo a ON (ad.idArtigo = a.idArtigo) INNER JOIN documento d ON (ad.idDocumento = d.idDocumento) INNER JOIN usuario u ON (d.idUsuario = u.idUsuario)";

		if (stripos($sql, "WHERE") == false) {
			if ($dataInicial != null || $dataFinal != null || $ano != null || $anoMes != null) {
				$sql .= " WHERE";
			}
		}

		if ($totais == "mensais") {
			if ($anoMes != null && $mes != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $anoMes . "'" . " AND MONTH(datadoc) = " . "'" . $mes . "'";
			}
		} else if ($totais == "anuais") {
			if ($ano != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $ano . "'";
			}
		} else if ($totais == "entreDatas") {
			if ($dataInicial != null && $dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) BETWEEN " . "'" . $dataInicial . "'" . " AND " . "'" . $dataFinal . "'" . ")";
			} else if ($dataInicial != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataInicial . "'" . ")";
			} else if ($dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataFinal . "'" . ")";
			}
		}

		$sql .= " GROUP BY refUsuario ORDER BY datadoc";

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$imposto, $totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryVendaTotalEntidade($imposto, $totais, $anoMes, $mes, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal)
	{
		$data = null;
		$sql = "SELECT u.idUsuario as refUsuario, u.nome as usuario, DATE(datadoc) AS dataDocumento, DAY(datadoc) AS dia, SUM(qtd) AS qtd, SUM(desconto) AS desconto, SUM(d.entregue) AS totalEntregue, SUM(d.total) AS totalAbsoluto, SUM(troco) AS totalTroco,";

		if ($imposto == "0") {
			$sql .= " (SUM(a.precoCustoSemImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoSemImp) * qtd) AS lucro";
		} else if ($imposto == "1") {
			$sql .= " (SUM(a.precoCustoComImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoComImp) * qtd) AS lucro";
		}

		$sql .= " FROM artigodocumento ad INNER JOIN artigo a ON (ad.idArtigo = a.idArtigo) INNER JOIN documento d ON 
		(ad.idDocumento = d.idDocumento) INNER JOIN usuario u ON (d.idUsuario = u.idUsuario)";

		if (stripos($sql, "WHERE") == false) {
			if ($dataInicial != null || $dataFinal != null || $ano != null || $anoMes != null) {
				$sql .= " WHERE";
			}
		}

		if ($totais == "mensais") {
			if ($anoMes != null && $mes != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $anoMes . "'" . " AND MONTH(datadoc) = " . "'" . $mes . "'";
			}
		} else if ($totais == "anuais") {
			if ($ano != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $ano . "'";
			}
		} else if ($totais == "entreDatas") {
			if ($dataInicial != null && $dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) BETWEEN " . "'" . $dataInicial . "'" . " AND " . "'" . $dataFinal . "'" . ")";
			} else if ($dataInicial != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataInicial . "'" . ")";
			} else if ($dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataFinal . "'" . ")";
			}
		}

		$sql .= " GROUP BY refUsuario ORDER BY datadoc";

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$imposto, $totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTotalEntidade($idTipoEntidade, $imposto, $totais, $anoMes, $mes, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal)
	{
		$data = null;
		$sql = "SELECT e.idEntidade as refEntidade, e.nome as entidade, DATE(datadoc) AS dataDocumento, DAY(datadoc) AS dia, SUM(qtd) AS qtd, SUM(desconto) AS desconto, SUM(d.entregue) AS totalEntregue, SUM(d.total) AS totalAbsoluto, SUM(troco) AS totalTroco,";

		if ($imposto == "0") {
			$sql .= " (SUM(a.precoCustoSemImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoSemImp) * qtd) AS lucro";
		} else if ($imposto == "1") {
			$sql .= " (SUM(a.precoCustoComImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoComImp) * qtd) AS lucro";
		}

		$sql .= " FROM artigodocumento ad INNER JOIN artigo a ON (ad.idArtigo = a.idArtigo) INNER JOIN documento d ON (ad.idDocumento = d.idDocumento) INNER JOIN usuario u ON (d.idUsuario = u.idUsuario) INNER JOIN entidade e ON (d.idEntidade = e.idEntidade)";

		if (stripos($sql, "WHERE") == false) {
			if ($dataInicial != null || $dataFinal != null || $ano != null || $anoMes != null) {
				$sql .= " WHERE";
			}
		}

		if ($totais == "mensais") {
			if ($anoMes != null && $mes != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $anoMes . "'" . " AND MONTH(datadoc) = " . "'" . $mes . "'";
			}
		} else if ($totais == "anuais") {
			if ($ano != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $ano . "'";
			}
		} else if ($totais == "entreDatas") {
			if ($dataInicial != null && $dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) BETWEEN " . "'" . $dataInicial . "'" . " AND " . "'" . $dataFinal . "'" . ")";
			} else if ($dataInicial != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataInicial . "'" . ")";
			} else if ($dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataFinal . "'" . ")";
			}
		}

		if ($idTipoEntidade != 0) {
			if (stripos($sql, "WHERE") == false) {
				$sql .= " WHERE";
				$sql .= " (" . "idTipoEntidade = " . $idTipoEntidade . ")";
			} else {
				$sql .= " AND " . " (" . "idTipoEntidade = " . $idTipoEntidade . ")";
			}
		}

		$sql .= " GROUP BY refEntidade ORDER BY datadoc";

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$imposto, $totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTotalArtigoEntidade($tabela, $parametros)
	{
		return $tabela;
		/*$data = null;
		$sql = "SELECT a.idArtigo AS refArtigo, a.nome AS descricao, e.idEntidade AS refEntidade, e.nome AS entidade, DATE(datadoc) AS dataDocumento, DAY(datadoc) AS dia, SUM(qtd) AS qtd, SUM(desconto) AS desconto, SUM(d.entregue) AS totalEntregue, SUM(d.total) AS totalAbsoluto, SUM(troco) AS totalTroco,";

		if ($imposto == "0") {
			$sql .= " (SUM(a.precoCustoSemImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoSemImp) * qtd) AS lucro";
		} else if ($imposto == "1") {
			$sql .= " (SUM(a.precoCustoComImp) * qtd) AS custo, (SUM(ad.preco - a.precoCustoComImp) * qtd) AS lucro";
		}

		$sql .= " FROM artigodocumento ad INNER JOIN artigo a ON (ad.idArtigo = a.idArtigo) INNER JOIN documento d ON (ad.idDocumento = d.idDocumento) INNER JOIN usuario u ON (d.idUsuario = u.idUsuario) INNER JOIN entidade e ON (d.idEntidade = e.idEntidade)";

		if (stripos($sql, "WHERE") == false) {
			if ($dataInicial != null || $dataFinal != null || $ano != null || $anoMes != null) {
				$sql .= " WHERE";
			}
		}

		if ($totais == "mensais") {
			if ($anoMes != null && $mes != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $anoMes . "'" . " AND MONTH(datadoc) = " . "'" . $mes . "'";
			}
		} else if ($totais == "anuais") {
			if ($ano != null) {
				$sql .= " YEAR(datadoc) = " . "'" . $ano . "'";
			}
		} else if ($totais == "entreDatas") {
			if ($dataInicial != null && $dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) BETWEEN " . "'" . $dataInicial . "'" . " AND " . "'" . $dataFinal . "'" . ")";
			} else if ($dataInicial != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataInicial . "'" . ")";
			} else if ($dataFinal != null) {
				$sql .= " (" . "DATE(dataDoc) = " . "'" . $dataFinal . "'" . ")";
			}
		}

		if ($entidadeInicial != null && $entidadeFinal != null) {
			if (stripos($sql, "WHERE") == false) {
				$sql .= " WHERE";
				$sql .= " (" . "e.idEntidade BETWEEN " . $entidadeInicial . " AND " . $entidadeFinal . ")";
			} else {
				$sql .= " (" . "e.idEntidade BETWEEN " . $entidadeInicial . " AND " . $entidadeFinal . ")";
			}
		} else if ($entidadeInicial != null) {
			if (stripos($sql, "WHERE") == false) {
				$sql .= " WHERE";
				$sql .= " (" . "e.idEntidade = " . $entidadeInicial . ")";
			} else {
				$sql .= " (" . "e.idEntidade = " . $entidadeInicial . ")";
			}
		} else if ($entidadeFinal != null) {
			if (stripos($sql, "WHERE") == false) {
				$sql .= " WHERE";
				$sql .= " (" . "e.idEntidade = " . $entidadeFinal . ")";
			} else {
				$sql .= " (" . "e.idEntidade = " . $entidadeInicial . ")";
			}
		}

		$sql .= " GROUP BY refArtigo ORDER BY datadoc";

		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$imposto, $totais, $ano, $dataInicial, $dataFinal, $terminais, $idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}*/
		/*$parameter = [];
		for($i = 0; $i < count($parametros); $i++){
			$parameter[] = $parametros[$i]["Campo"];
		}
		$dataString = implode(" AND ", $parameter);
		return $dataString;*/
	}
}
