<?php

    class SignUpModel extends Database {

        protected function insertUsuario($nome, $nomeUsuario, $telefone, $email, $senha){
            $stmt = $this->connect();
            $sql = "INSERT INTO estudante (nome, nomeUsuario, telefone, email, senha) VALUES (?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            $hashedSenha = password_hash($senha, PASSWORD_DEFAULT);

            if(!($query->execute(array($nome, $nomeUsuario, $telefone, $email, $hashedSenha)))){
                $query = null;
				header("location: ../signup.php?Erro=stmtFalhou!");
				exit();
            }
            $stmt = null;  
        }

        protected function checkUser($nomeUsuario, $email){
            $stmt = $this->connect();
            $sql = "SELECT * FROM estudante WHERE idEstudante = ? OR email = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nomeUsuario, $email)))){
                $query = null;
				header("location: ../signup.php?Erro=stmtFalhou!");
				exit();
            }  

            if($query->rowCount() > 0){
                $resultCheck = false;
            } else {
                $resultCheck = true;
            }
            return $resultCheck;
        }
    }