<?php

class TaxaModel extends Database {

	protected function insertTaxa($idCodigoTaxa, $idTipoTaxa, $idRegiao, $idImposto){
		$stmt = $this->connect();
		$sql = "INSERT INTO taxa (idCodigoTaxa, idTipoTaxa, idRegiao, idImposto) VALUES (?, ?, ?, ?)";
		$query = $stmt->prepare($sql);
		if(!($query->execute(array($idCodigoTaxa, $idTipoTaxa, $idRegiao, $idImposto)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

		protected function editTaxa($idTaxa, $idCodigoTaxa, $idTipoTaxa, $idRegiao, $idImposto){
			$sql = "UPDATE taxa SET idCodigoTaxa = ?, idTipoTaxa = ?, idRegiao = ?, idImposto = ? WHERE idTaxa = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idCodigoTaxa, $idTipoTaxa, $idRegiao, $idImposto, $idTaxa))){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}
		
		public function parentTaxa(){
			$data = null;
			$sql = "SELECT * FROM taxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function readCodigoTaxa(){
			$data = null;
			$sql = "SELECT COALESCE(MAX(idTaxa), 0) + 1 AS contador FROM taxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryTaxa($idTaxa){
			$data = null;
			$sql = "SELECT * FROM viewImposto WHERE idTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemTaxa(){
			$data = null;
			$sql = "SELECT * FROM viewImposto";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemTaxaEstado($estado){
			$data = null;
			$sql = "SELECT * FROM viewImposto WHERE estadoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$estado]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function deleteTaxa($idTaxa){
			$sql = "DELETE FROM taxa WHERE idTaxa = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute([$idTaxa])){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}

		protected function funcaoReadTaxa(){
			$sql = "SELECT * FROM taxa";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<option name="idTaxa" value="'.$row['idTaxa'].'">' . $row['idCodigoTaxa'] . '</option>';//'<option value='"$row['idTaxa']"'>'"$row['idCodigoTaxa']"'</option>';
				//echo $row['idUsuario'];
				//echo $row['idCodigoTaxa'];
			}

		}

		protected function listaTaxa(){
			$sql = "SELECT * FROM taxa";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idTaxa'].'</td>
					<td>'.$row['idCodigoTaxa'].'</td>
					<td>
						<a href="../includes/TaxaUpdate.inc.php?id='.$row['idTaxa'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/TaxaDelete.inc.php?id='.$row['idTaxa'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}

		protected function countTaxa(){
			$sql = "SELECT COUNT(*) FROM taxa";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}
	}