<?php

class TerminalModel extends Database
{

	protected function insertTerminal($idUsuario, $idArmazem, $nome, $endereco, $nota)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO terminal (idUsuario, idArmazem, nome, endereco, nota) VALUES (?, ?, ?, ?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idUsuario, $idArmazem, $nome, $endereco, $nota)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editTerminal($idTerminal, $idUsuario, $idArmazem, $nome, $endereco, $nota)
	{
		$sql = "UPDATE terminal SET idArmazem = ?, nome = ?, endereco = ?, nota = ? WHERE idTerminal = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute(array($idArmazem, $nome, $endereco, $nota, $idTerminal))) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	public function parentTerminal()
	{
		$data = null;
		$sql = "SELECT * FROM terminal";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readCodigoTerminal()
	{
		$data = null;
		$sql = "SELECT COALESCE(MAX(idTerminal), 0) + 1 AS contador FROM terminal";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTerminal($idTerminal)
	{
		$data = null;
		$sql = "SELECT * FROM viewterminal WHERE idTerminal = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTerminal]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemTerminal()
	{
		$data = null;
		$sql = "SELECT * FROM viewTerminal";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function deleteTerminal($idTerminal)
	{
		$sql = "DELETE FROM terminal WHERE idTerminal = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute([$idTerminal])) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	protected function selectTerminal()
	{
		$sql = "SELECT * FROM terminal";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<option name="idTerminal" value="' . $row['idTerminal'] . '">' . $row['nome'] . '</option>'; //'<option value='"$row['idTerminal']"'>'"$row['nome']"'</option>';
			//echo $row['idUsuario'];
			//echo $row['nome'];
		}
	}

	protected function listaTerminal()
	{
		$sql = "SELECT * FROM terminal";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<tr>
					<td>' . $row['idTerminal'] . '</td>
					<td>' . $row['nome'] . '</td>
					<td>
						<a href="../includes/TerminalUpdate.inc.php?id=' . $row['idTerminal'] . '" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/TerminalDelete.inc.php?id=' . $row['idTerminal'] . '"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
		}
	}

	protected function countTerminal()
	{
		$sql = "SELECT COUNT(*) FROM terminal";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		echo $results['COUNT(*)'];
	}

	public function autoIncrementTerminal()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'terminal';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}
}
