<?php
    class TipoMatriculaModel extends Database {

		protected function insertTipoMatricula($nome, $nota){
			$stmt = $this->connect();
            $sql = "INSERT INTO tipoMatricula (nome, nota) VALUES (?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemTipoMatricula(){
			$data = null;
			$sql = "SELECT * FROM tipoMatricula;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editTipoMatricula($idTipoMatricula, $nome, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE tipoMatricula SET nome = ?, nota = ? WHERE idTipoMatricula = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $nota, $idTipoMatricula)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteTipoMatricula($idTipoMatricula){
			$stmt = $this->connect();
            $sql = "DELETE FROM tipoMatricula WHERE idTipoMatricula = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idTipoMatricula)))){
				$query = null;
				exit();
			}
		}

		public function queryTipoMatricula($idTipoMatricula){
			$data = null;
			$sql = "SELECT * FROM tipoMatricula WHERE idTipoMatricula = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoMatricula]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}
    }