<?php
    class UnidadeMedidaModel extends Database {

		protected function insertUnidadeMedida($nome, $sigla, $tipo, $casaDecimal){
            $stmt = $this->connect();
            $sql = "INSERT INTO unidadeMedida (nome, sigla, tipo, casaDecimal) VALUES (?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nome, $sigla, $tipo, $casaDecimal)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemUnidadeMedida(){
			$data = null;
			$sql = "SELECT * FROM unidadeMedida";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryUnidadeMedida($idUnidadeMedida){
			$data = null;
			$sql = "SELECT * FROM unidadeMedida WHERE idUnidadeMedida = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUnidadeMedida]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editUnidadeMedida($idUnidadeMedida, $nome, $sigla, $tipo, $casaDecimal){
			$stmt = $this->connect();
			
            $sql = "UPDATE unidadeMedida SET nome = ?, sigla = ?, tipo = ?, casaDecimal = ? WHERE idUnidadeMedida = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $sigla, $tipo, $casaDecimal, $idUnidadeMedida)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteUnidadeMedida($idUnidadeMedida){
			$stmt = $this->connect();
            $sql = "DELETE FROM unidadeMedida WHERE idUnidadeMedida = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idUnidadeMedida)))){
				$query = null;
				exit();
			}
		}
    }