<?php include('header.php'); ?>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- SELECT2 EXAMPLE -->
            <div class="col-md-6">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Grupo de Taxas</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group row">
                        <small class="not-required col-sm-2 col-form-label">Código:</small>
                        <div class="col-sm-10">
                          <div class="input-group input-group">
                            <select class="form-control select2" id="idCodigo">
                            </select>
                            <div class="input-group-append">
                              <button type="button" id="btn-codigo" class="btn btn btn-default" style="line-height: 0;">
                                <i class="fa-solid fa-plus" style="color: #560085; font-size: 1.2rem;"></i>
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="form-group row">
                        <small class="not-required col-sm-2 col-form-label">Tipo:</small>
                        <div class="col-sm-10">
                          <div class="input-group input-group">
                            <select class="form-control select2" id="idTipo">
                            </select>
                            <div class="input-group-append">
                              <button type="button" id="btn-tipo" class="btn btn btn-default" style="line-height: 0;">
                                <i class="fa-solid fa-plus" style="color: #560085; font-size: 1.2rem;"></i>
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="form-group row">
                        <small class="not-required col-sm-2 col-form-label">Região:</small>
                        <div class="col-sm-10">
                          <div class="input-group input-group">
                            <select class="form-control select2" id="idRegiao">
                            </select>
                            <div class="input-group-append">
                              <button type="button" id="btn-regiao" class="btn btn btn-default" style="line-height: 0;">
                                <i class="fa-solid fa-plus" style="color: #560085; font-size: 1.2rem;"></i>
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="form-group row">
                        <small class="not-required col-sm-2 col-form-label">Taxa:</small>
                        <div class="col-sm-10">
                          <div class="input-group input-group">
                            <select class="form-control select2" id="idTaxa">
                            </select>
                            <div class="input-group-append">
                              <button type="button" id="btn-taxa" class="btn btn btn-default" style="line-height: 0;">
                                <i class="fa-solid fa-plus" style="color: #560085; font-size: 1.2rem;"></i>
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <!-- /.row -->
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  Impostos do sistema.
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Impostos</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body p-0">
                  <table class="table table-striped" id="tabelaImposto">
                    <thead>
                      <tr>
                        <th>Código de Taxa</th>
                        <th>Código do Tipo de Taxa</th>
                        <th>Descrição da Região</th>
                        <th>Descrição Total da Taxa</th>
                      </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                  <!-- /.row -->
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  Impostos do sistema.
                </div>
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div>
        <!-- /.container-fluid -->
      </section>
    </div>
    <div class="modal fade" id="modal-codigo">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Código da Taxa</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Descrição</small>
                  <input type="text" class="form-control" id="nomeCodigoTaxa" placeholder="Descrição" title="Descrição Código Taxa">
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Estado</small>
                  <select class="form-control select2" style="width: 100%;" id="estadoCodigoTaxa" name="estadoCodigoTaxa">
                    <option value="0">Inactivo</option>
                    <option value="1">Activo</option>
                  </select>
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="not-required">Observações</small>
                  <textarea class="form-control" name="" id="notaCodigoTaxa" rows="1"></textarea>
                  <small>Mensagem de erro</small>
                </div>
              </div>
              <div class="col-md-8">
                <table class="table table-bordered table-striped" id="tabelaImposto">
                  <thead>
                    <tr>
                      <th>Código de Taxa</th>
                      <th>Código do Tipo de Taxa</th>
                      <th>Descrição da Região</th>
                      <th>Descrição Total da Taxa</th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
            <button type="button" class="btn btn-primary" id="btn-codigoTaxa">Cadastrar</button>
          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="modal-tipo">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Tipo de Taxa</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Código</small>
                  <input type="text" class="form-control" id="codigoTipoTaxa" placeholder="Código Tipo Taxa" title="Código Tipo Taxa">
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Descrição</small>
                  <input type="text" class="form-control" id="nomeTipoTaxa" placeholder="Descrição" title="Descrição Código Taxa">
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Estado</small>
                  <select class="form-control select2" style="width: 100%;" id="estadoTipoTaxa">
                    <option value="0">Inactivo</option>
                    <option value="1">Activo</option>
                  </select>
                  <small>Mensagem de erro</small>
                </div>
              </div>
              <div class="col-md-8">
                <table class="table table-bordered table-striped" id="tabelaImposto">
                  <thead>
                    <tr>
                      <th>Código de Taxa</th>
                      <th>Código do Tipo de Taxa</th>
                      <th>Descrição da Região</th>
                      <th>Descrição Total da Taxa</th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
            <button type="button" class="btn btn-primary" id="btn-tipoTaxa">Cadastrar</button>
          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="modal-regiao">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Região</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Código</small>
                  <input type="text" class="form-control" id="codigoRegiao" placeholder="Código Tipo Taxa" title="Código Tipo Taxa">
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Descrição</small>
                  <input type="text" class="form-control" id="nomeRegiao" placeholder="Descrição" title="Descrição Código Taxa">
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">País</small>
                  <select class="form-control select2" style="width: 100%;" id="idPais">
                  </select>
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Estado</small>
                  <select class="form-control select2" style="width: 100%;" id="estadoRegiao">
                    <option value="0">Inactivo</option>
                    <option value="1">Activo</option>
                  </select>
                  <small>Mensagem de erro</small>
                </div>
              </div>
              <div class="col-md-8">
                <table class="table table-bordered table-striped" id="tabelaImposto">
                  <thead>
                    <tr>
                      <th>Código de Taxa</th>
                      <th>Código do Tipo de Taxa</th>
                      <th>Descrição da Região</th>
                      <th>Descrição Total da Taxa</th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
            <button type="button" class="btn btn-primary" id="btn-regiaoTaxa">Cadastrar</button>
          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="modal-taxa">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Taxa</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Código</small>
                  <input type="text" class="form-control" id="codigoRegiao" placeholder="Código Tipo Taxa" title="Código Tipo Taxa">
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Descrição</small>
                  <input type="text" class="form-control" id="nomeRegiao" placeholder="Descrição" title="Descrição Código Taxa">
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">País</small>
                  <select class="form-control select2" style="width: 100%;" id="idPais">
                  </select>
                  <small>Mensagem de erro</small>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                  <small class="required">Estado</small>
                  <select class="form-control select2" style="width: 100%;" id="estadoRegiao">
                    <option value="0">Inactivo</option>
                    <option value="1">Activo</option>
                  </select>
                  <small>Mensagem de erro</small>
                </div>
              </div>
              <div class="col-md-8">
                <table class="table table-bordered table-striped" id="tabelaImposto">
                  <thead>
                    <tr>
                      <th>Código de Taxa</th>
                      <th>Código do Tipo de Taxa</th>
                      <th>Descrição da Região</th>
                      <th>Descrição Total da Taxa</th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
            <button type="button" class="btn btn-primary" id="btn-regiaoTaxa">Cadastrar</button>
          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <!-- /.content-wrapper -->
    <?php include('footer.php'); ?>
</body>

</html>
<script src="./javascript/function.js"></script>
<script>
  $(document).on("click", "#btn-codigo", function(e) {
    e.preventDefault();
    $('#modal-codigo').modal('show');
  });

  $(document).on("click", "#btn-tipo", function(e) {
    e.preventDefault();
    $('#modal-tipo').modal('show');
  });

  $(document).on("click", "#btn-regiao", function(e) {
    e.preventDefault();
    $('#modal-regiao').modal('show');
  });

  $(document).on("click", "#btn-taxa", function(e) {
    e.preventDefault();
    $('#modal-taxa').modal('show');
  });

  $(document).ready(function() {
    reload();
    funcaoReadCodigoTaxa(function success(data) {
      let select = "";
      for (let i = 0; i < data.length; i++) {
        select += "<option value=" + data[i]['idCodigoTaxa'] + ">" + data[i]['nome'] + "</option>";
      }
      $("#idCodigo").html(select);
    }, function error(data) {

    }, function done(data) {

    });

    funcaoReadPais(function success(data) {
      let select = "";
      for (let i = 0; i < data.length; i++) {
        select += "<option value=" + data[i]['idPais'] + ">" + data[i]['descricao'] + "</option>";
      }
      $("#idPais").html(select);
    }, function error(data) {

    }, function done(data) {

    });

    funcaoReadTipoTaxa(function success(data) {
      let select = "";
      for (let i = 0; i < data.length; i++) {
        select += "<option value=" + data[i]['idTipoTaxa'] + ">" + data[i]['codigo'] + "</option>";
      }
      $("#idTipo").html(select);
    }, function error(data) {

    }, function done(data) {

    });

    funcaoReadRegiao(function success(data) {
      let select = "";
      for (let i = 0; i < data.length; i++) {
        select += "<option value=" + data[i]['idRegiao'] + ">" + data[i]['designacao'] + "</option>";
      }
      $("#idRegiao").html(select);
    }, function error(data) {

    }, function done(data) {

    });

    funcaoReadTaxaEstado(0, function success(data) {
      let select = "";
      for (let i = 0; i < data.length; i++) {
        select += "<option value=" + data[i]['idTaxa'] + ">" + data[i]['nomeCodigoTaxa'] + "</option>";
      }
      $("#idTaxa").html(select);
    }, function error(data) {

    }, function done(data) {

    });

    funcaoReadTaxaEstado(1, function success(data) {
      let select = "";
      for (let i = 0; i < data.length; i++) {
        select += `
    <tr>
      <td>${data[i]['nomeCodigoTaxa']}</td>
      <td>${data[i]['codigoTipoTaxa']}</td>
      <td>${data[i]['descricaoRegiao']}</td>
      <td>${data[i]['descricaoTotalTaxa']}</td>
    </tr>`;
      }
      $("#tabelaImposto tbody").html(select);
    }, function error(data) {

    }, function done(data) {

    });

    $.ajax({
      url: "includes/read/pais.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        let select = "";
        for (var key in data) {
          select += "<option value=" + data[key]['idPais'] + ">" + data[key]['descricao'] + "</option>";
        }
        console.log(select);
        $("#pais").html(select);
      }
    }).done(function(data) {
      $.ajax({
        url: "includes/read/definicao.inc.php",
        type: "post",
        dataType: "json",
        success: function(data) {
          for (key in data) {
            if (data[key]["idDefinicao"] == 4) {
              $('#pais').val(data[key]['valor']);
              $('#pais').select2().trigger('change');
            }
          }
        }
      });
    });

    $.ajax({
      url: "includes/read/serie.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        let select = "";
        for (var key in data) {
          select += "<option value=" + data[key]['idSerie'] + ">" + data[key]['descricao'] + "</option>";
        }
        console.log(select);
        $("#serie").html(select);
      }
    }).done(function(data) {
      $.ajax({
        url: "includes/read/definicao.inc.php",
        type: "post",
        dataType: "json",
        success: function(data) {
          for (key in data) {
            if (data[key]["idDefinicao"] == 3) {
              $('#serie').val(data[key]['valor']);
              $('#serie').select2().trigger('change');
            }
          }
        }
      });
    });

    $.ajax({
      url: "includes/read/moeda.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        let select = "";
        for (var key in data) {
          select += "<option value=" + data[key]['idMoeda'] + ">" + data[key]['nome'] + "</option>";
        }
        console.log(select);
        $("#moeda").html(select);
      }
    }).done(function(data) {
      $.ajax({
        url: "includes/read/definicao.inc.php",
        type: "post",
        dataType: "json",
        success: function(data) {
          for (key in data) {
            if (data[key]["idDefinicao"] == 5) {
              $('#moeda').val(data[key]['valor']);
              $('#moeda').select2().trigger('change');
            }
          }
        }
      });
    });
  });

  function reload() {
    $.ajax({
      url: "includes/read/definicao.inc.php",
      type: "post",
      dataType: "json",
      success: function(data) {
        let select = "";
        for (var key in data) {
          if (data[key]["idDefinicao"] == 1) {
            qtdLinhaPreco.value = data[key]["valor"];
            for (let i = 0; i < data[key]["valor"]; i++) {
              select += `<option value="${i + 1}">P.Venda (${i + 1})</option>`;
            }
          }

          if (data[key]["idDefinicao"] == 5) {
            $('#moeda').val(data[key]['valor']);
            $('#moeda').select2().trigger('change');
          }

          if (data[key]["idDefinicao"] == 3) {
            $('#serie').val(data[key]['valor']);
            $('#serie').select2().trigger('change');
          }

          if (data[key]["idDefinicao"] == 4) {
            $('#pais').val(data[key]['valor']);
            $('#pais').select2().trigger('change');
          }

          if (data[key]["idDefinicao"] == 6) {
            $('#tipoPrograma').val(data[key]['valor']);
            $('#tipoPrograma').select2().trigger('change');
          }

          if (data[key]["idDefinicao"] == 7) {
            retencaoFonte.value = parseFloat(data[key]['valor']).toFixed(2).replace(/\ /g, '').replace(/\./g, ',');
          }

          if (data[key]["idDefinicao"] == 8) {
            $('#regimeFiscal').val(data[key]['valor']);
            $('#regimeFiscal').select2().trigger('change');
          }
        }
        $("#linhaPrecoPredefinida").html(select);
      }
    }).done(function(data) {
      for (var key in data) {
        if (data[key]["idDefinicao"] == 2) {
          $('#linhaPrecoPredefinida').val(data[key]['valor']);
          $('#linhaPrecoPredefinida').select2().trigger('change');
        }
      }
    });
  }
  $(document).on("click", "#btn-submit", function(e) {
    e.preventDefault();
    $.ajax({
      url: "includes/create/definicao.inc.php",
      type: "post",
      data: {
        pais: pais.value,
        serie: serie.value,
        moeda: moeda.value,
        qtdLinhaPreco: qtdLinhaPreco.value,
        linhaPrecoPredefinida: linhaPrecoPredefinida.value,
        tipoPrograma: tipoPrograma.value,
        retencaoFonte: parseFloat(retencaoFonte.value.replace(/\ /g, '').replace(/\,/g, '.')),
        regimeFiscal: regimeFiscal.value
      },
      success: function(data) {
        reload();
        console.log(data);
        swal.fire({
          title: "Alterações gravadas com sucesso!",
          text: "Impostos gravadas!",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "success",
        });
      },
      error: function(data) {
        reload();
        swal.fire({
          title: "Erro ao alterar Impostos!",
          text: "Erro ao alterar Impostos.",
          confirmButtonText: 'Confirmar',
          confirmButtonColor: '#560085',
          icon: "error",
        });
      }
    });
  });
</script>
<script src="./validation/definicao.js"></script>