<?php include('header.php'); ?>

<body class="hold-transition layout-top-nav">
  <div class="wrapper">
    <div class="preloader flex-column justify-content-center align-items-center">
      <img class="animation__shake" src="images/logo/<?php echo $rows[9]['valor']; ?>" alt="AdminLTELogo" height="60" width="60">
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- SELECT2 EXAMPLE -->
            <div class="col-md-6">
              <div class="card card-default">
                <div class="card-header">
                  <h3 class="card-title">Lotes</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group margem" style="margin-bottom: 0;">
                        <small class="not-required">Código</small>
                        <div class="input-group input-group">
                          <input type="text" class="form-control form-control" id="codigo" name="codigo" placeholder="Pesquisar Entidade" title="Pesquisar Entidade" disabled>
                          <div class="input-group-append">
                            <button type="button" id="btn-search" class="btn btn btn-default" style="line-height: 0 ;">
                              <i class="fa fa-search"></i>
                            </button>
                          </div>
                        </div>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Descrição</small>
                        <input type="text" class="form-control" id="descricao" name="descricao" placeholder="Descrição" title="Descrição" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Dias mínimos de Expiração</small>
                        <input type="number" class="form-control" id="diaExp" name="diaExp" placeholder="Dias mínimos de Expiração" title="Dias mínimos de Expiração" required>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <div class="custom-control custom-checkbox">
                          <input class="custom-control-input" type="checkbox" id="dataExp" value="0">
                          <label for="dataExp" class="custom-control-label">Pedir data de Expiração</label>
                        </div>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Tipo de Movimento</small>
                        <select class="form-control select2" style="width: 100%;" id="tipoMovimento" name="tipoMovimento">
                          <option value="0">Selecione um Tipo de Movimento</option>
                          <option value="entrada">Entrada</option>
                          <option value="saida">Saída</option>
                          <option value="entradaSaida">Entrada e Saída</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Sugestão de Movimento</small>
                        <select class="form-control select2" style="width: 100%;" id="sugestaoMovimento" name="sugestaoMovimento">
                          <option value="0">Selecione um Sugestão de Movimento</option>
                          <option value="fifo" title="FIFO (Primeiro a entrar - Primeiro a Sair)">FIFO</option>
                          <option value="lifo" title="LIFO (Último a entrar - Primeiro a Sair)">LIFO</option>
                          <option value="fefo" title="FEFO (Primeiro expirado - Primeiro a Sair)">FEFO</option>
                          <option value="lefo" title="LEFO (Último expirado - Primeiro a Sair)">LEFO</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <small class="required">Movimentar Expirados</small>
                        <select class="form-control select2" style="width: 100%;" id="movExp" name="movExp">
                          <option value="0">Selecione uma das opções</option>
                          <option value="permitir">Permitir</option>
                          <option value="naoPermitir">Não Permitir</option>
                        </select>
                        <small>Mensagem de erro</small>
                      </div>
                      <div class="form-group" style="margin-bottom: 0;">
                        <div class="custom-control custom-checkbox">
                          <input class="custom-control-input" type="checkbox" id="dataProd" value="0">
                          <label for="dataProd" class="custom-control-label">Pedir data de Produção</label>
                        </div>
                      </div>
                    </div>
                    <!-- /.col -->
                  </div>
                  <!-- /.row -->
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /.card -->
    </div>
    <!-- /.container-fluid -->
    </section>
  </div>
  <!-- /.content-wrapper -->
  <?php include('footer.php'); ?>
</body>

</html>
<script src="./validation/lote.js"></script>
<script>

$(document).on("click", "#dataExp", function(e) {
    if (this.checked) {
      this.value = 1;
    } else {
      this.value = 0;
    }
  });

  $(document).on("click", "#dataProd", function(e) {
    if (this.checked) {
      this.value = 1;
    } else {
      this.value = 0;
    }
  });

  $(document).ready(function() {
    codigoLote();
    formLoteButton();
  });

  $(window.parent.document).on("click", "#btn-submit", function(e) {
    e.preventDefault();
    if (nome.value != '') {
      $.ajax({
        url: "includes/create/lote.inc.php",
        type: "post",
        data: {
          idUsuario: <?php echo $_SESSION["usuarioId"]; ?>,
          descricao: descricao.value,
          tipoMovimento: tipoMovimento.value,
          sugestaoMovimento: sugestaoMovimento.value,
          movExp: movExp.value,
          dataExp: dataExp.value,
          dataProd: dataProd.value
        },
        success: function(data) {
          swal.fire({
            title: "Cadastro efectuado com sucesso!",
            text: "Lotes " + descricao.value + " cadastrado!",
            confirmButtonText: 'Confirmar',
            confirmButtonColor: "#560085",
            icon: "success",
          });
          descricao.value = "";
          descricao.className = "form-control";
          nota.value = "";
          nota.className = "form-control";
        },
        error: function(data) {
          swal.fire({
            title: "Erro ao Cadastrar Lotes!",
            text: "Erro ao Cadastrar Lotes: " + nome.value + " !",
            confirmButtonText: 'Confirmar',
            icon: "error",
          });
        }
      }).done(function(data) {
        codigoLote();
        formLoteButton();
        console.log(data);
      });
    }
  });
</script>