<?php include('./header.php'); ?>
<style type="text/css">
    .logo img {
        width: 150px;
    }

    .container .form-outer {
        width: 100%;
        overflow: hidden;
    }

    .form-outer .formulario {
        display: flex;
        width: 400%;
    }

    .form-outer .formulario .page {
        width: 25%;
        transition: margin-left 0.3s ease-in-out;
    }

    .form-outer .formulario .page .field {
        display: flex;
    }

    .form-outer .formulario .page .field button:hover {
        background-color: #66009f;
        border-color: #66009f;
    }

    .form-outer .formulario .page .field button {
        background-color: #560085;
        border-color: #560085;
    }

    .formulario .page .btns button.prev {
        margin-right: 3px !important;
        font-size: 17px;
    }

    .formulario .page .btns button.next {
        margin-left: 3px !important;
    }

    .invisible{
        display: none;
    }

    .container .progress-barra {
        display: flex;
        justify-content: space-between;
    }

    .container .progress-barra .step {
        position: relative;
        text-align: center;
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
    }

    .progress-barra .step p {
        font-size: 14px;
        font-weight: 500;
        color: #666;
        margin-bottom: 8px;
        transition: 0.2s;
    }

    .progress-barra .step p.active {
        color: #560085;
    }

    .progress-barra .step .bullet {
        position: relative;
        height: 35px;
        width: 35px;
        border: 2px solid #666;
        display: inline-block;
        border-radius: 50%;
        transition: 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .progress-barra .step .bullet.active {
        border-color: #560085;
        background: #560085;
    }

    .progress-barra .step .bullet span {
        font-weight: 500;
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
    }

    .progress-barra .step .bullet.active span {
        display: none;
    }

    .progress-barra .step:last-child .bullet:before,
    .progress-barra .step:last-child .bullet:after {
        display: none;
    }

    .progress-barra .step .bullet:before,
    .progress-barra .step .bullet:after {
        position: absolute;
        content: '';
        right: -14.35rem;
        height: 3px;
        width: 14rem;
        background: #666;
    }

    .progress-barra .step .bullet.active:after {
        background: #560085;
        transform: scaleX(0);
        transform-origin: left;
        animation: animate 0.3s linear forwards;
    }

    @keyframes animate {
        100% {
            transform: scaleX(1);
        }
    }

    .progress-barra .step .check {
        position: absolute;
        font-size: 15px;
        color: #666;
        display: none;
    }

    .progress-barra .step .check.active {
        display: block;
        color: #fff;
    }
</style>

<body class="hold-transition layout-top-nav">
    <div class="wrapper">
        <div class="preloader flex-column justify-content-center align-items-center">
        </div>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <div class="content-header">
                <div class="container-fluid">
                </div><!-- /.container-fluid -->
            </div>
            <!-- /.content-header -->

            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <!-- SELECT2 EXAMPLE -->
                        <div class="col-md-12">
                            <div class="card card-default">
                                <div class="card-body button-nav">
                                    <div class="row float-right">
                                        <div class="col-md-12">
                                            <button class="btn btn-opcao" id="btn-preview" disabled>Pré-visualizar</button>
                                            <button class="btn btn-opcao">Importar</button>
                                            <button class="btn btn-opcao botao-activo" id="btn">Novo Patrimônio</button>
                                        </div>
                                    </div>
                                    <!-- /.row -->
                                </div>
                                <!-- /.card-body -->
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="card card-default">
                                <div class="card-header">
                                    <h3 class="card-title">Listagem de Patrimônios</h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <!-- /.card-header -->
                                <div class="card-body">
                                    <table id="tabelaClasseMovimento" class="table table-bordered table-striped" style="line-height: 0.8;">
                                        <thead>
                                            <tr style="text-align: center;">
                                                <th title="Identificador do Patrimônio">Ref.</th>
                                                <th title="Tipo de Bem">Bem Patrimonial</th>
                                                
                                                <!-- <th title="Responsável Patrimônio">Código</th> -->
                                                <th title="Responsável Patrimônio">Localização</th>
                                                <th title="Responsável Patrimônio">Valor inicial</th>
                                                <th title="Responsável Patrimônio">Idade do Bem</th>
                                                <!-- <th title="Responsável Patrimônio">Valor Amortização</th> -->
                                                <th title="Responsável Patrimônio">Valor Residual</th>
                                                <th title="Responsável Patrimônio">Valor de Amortização</th>
                                                <th title="Responsável Patrimônio">Taxa de Amortização(%)</th>
                                                <th title="Data de Criação Patrimônio">Data</th>
                                                <th title="Opções"><i class="fa-solid fa-screwdriver-wrench"></i></th>
                                            </tr>
                                        </thead>
                                        <tbody id="corpoTabela" style="text-align: center;">

                                        </tbody>
                                    </table>
                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer">
                                    Listagem de Patrimônios
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.container-fluid -->
            </section>
            <div class="modal fade" id="modal-documento">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <div class="container">
                                <div class="progress-barra">
                                    <div class="step">
                                        <p style="margin: 0;">Formulário de Câmbios</p>
                                    </div>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="close">
                                        <small aria-hidden="true">
                                            <small class="fas fa-close"></small>
                                        </small>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="modal-body">
                            <div class="container">
                                <div class="card-body form-outer" style="padding: 0 !important;">
                                    <div class="formulario">
                                        <div class="page slidePage">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <h5 style="margin-bottom: 0rem; justify-content: center;">
                                                        <span id="doOpcao">Patrimônio</span> - <span id="codigo"></span>
                                                    </h5>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Patrimônio</small>
                                                                <input type="text" class="form-control" id="patrimonio_" name="tipo_bem" placeholder="Patrimônio" title="Taxa de Armotização" required>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Tipo de Bem Patrimonial</small>
                                                                <select name="" id="tipopatrimonio" class="form-control">
                                                                </select>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6 invisible" id="div-tax-amort">
                                                            <div class="form-group " style="margin-bottom: 0;">
                                                                <small class="required">Taxa de Amortização</small>
                                                                <input type="text" class="form-control" id="tax_amotizacao" name="tipo_bem" placeholder="Taxa de Armotização" disabled title="Taxa de Armotização" required>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6 invisible" id="div-valor-amort">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Valor de Amortização</small>
                                                                <input type="text" class="form-control" disabled id="valor_amortizacao" name="tipo_bem" placeholder="Taxa de Armotização" title="Valor de Armotização" required>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Código</small>
                                                                <select name="" id="code" class="form-control">
                                                                    <option value="" selected disabled>-- Selecione o Código --</option>
                                                                    <option value="barra">Código de Barra</option>
                                                                    <option value="qr">Código QR</option>
                                                                </select>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Valor Inicial</small>
                                                                <input type="text" class="form-control" id="preco_compra" name="tipo_bem" placeholder="Valor Inicial" title="Valor Inicial" required>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Valor Residual</small>
                                                                <input type="text" class="form-control" id="preco_venda" name="tipo_bem" placeholder="Valor Residual" title="Valor Residual" required>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Localização</small>
                                                                <select name="" id="localizacao" class="form-control">
                                                                    <option value="" selected disabled>-- Selecione a Localização --</option>
                                                                    <option value="">...</option>
                                                                    <option value="">...</option>
                                                                    <option value="own-localization">Informar outra Localização</option>
                                                                </select>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group" style="margin-bottom: 0;">
                                                                <small class="required">Idade do Bem</small>
                                                                <input type="text" class="form-control" id="idade_bem" name="tipo_bem" placeholder="Idade do Bem" title="Idade do Bem" required>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group own-localization d-none" style="margin-bottom: 0;">
                                                                <small class="required">Insere a tua Localização</small>
                                                                <input type="text" class="form-control" id="outra_localizacao" name="tipo_bem" placeholder="Localização" title="Localização" required>
                                                                <small>Mensagem de erro</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 ml-auto" style=" bottom: 0; padding-top: 14px;">
                                                    <div class="form-group margem">
                                                        <small>Mensagem de erro</small>
                                                        <div class="form-group field btns">
                                                            <button class="btn btn-block btn-primary submit next" id="gravarpartimonio" style="margin-top: 0;">
                                                                Gravar Patrimônio
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="modal-footer d-none">
                            <div class="col-md-12" id="footerPagamento" style="opacity: 0;">
                                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span id="totalEntregue">ENTREGUE</span><span id="entregueSpan">0,00 Kzs</span></h4>
                                <h4 style="display: flex; align-items: center; justify-content: space-between;"><span class="text-danger" id="totalText">TOTAL</span><span class="text-danger" id="totalSpan">0,00 Kzs</span></h4>
                            </div>
                        </div> -->
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>

            <!-- /.content-wrapper -->
            <?php include('footer.php'); ?>
</body>

</html>

<script>
    $('#btn').click(function() {
        // $('#moeda_padrao').val("Kz (AO)");
        $('#modal-documento').modal('show');
        // $('#doOpcao').html('Câmbio');
        $('#codigo').html('2024/1');

        $('#localizacao').change(function() {
            if ($(this).val() == 'own-localization') {
                $('.own-localization').removeClass('d-none');
            } else {
                $('.own-localization').addClass('d-none');
            }
        });
    });

    funcaoSelect("../pos/includes/select.inc.php", "post", "json", "patrimonio", function success(data) {
        console.log(data)
                $("#tabelaClasseMovimento").DataTable({
                    select: 'single',
                    "aaData": data,
                    "columns": [{
                      data: "idPatrimonio"
                    }, {
                      data: "patrimonio"
                    }, {
                      data: "localizacao"
                    }, {
                      data: "preco_custo"
                    }, {
                      data: "idade_bem"
                    }, {
                      data: "preco_venda"
                    },{
                      data: "valor_amortizacao"
                    },{
                      data: "tax_amortizacao"
                    }, {
                      data: "createdAt"
                    }, {
                      data: null,
                      render: function(data, type, row) {
                        return `
                        <div id="dropdownOpcoes" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="display:flex; align-items: center; justify-content: space-around;"><button class="btn btn-outline-primary opcoes" style="padding: .2rem .7rem; line-height: 1; border: none;"><i class="fa-solid fa-ellipsis-vertical"></i></button></div>
                        <ul aria-labelledby="dropdownOpcoes" class="dropdown-menu border-0 shadow">
                          <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-more" style="padding: .8rem; border-radius: 5px;">Informações</a></li>
                          <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-update" style="padding: .8rem; border-radius: 5px;">Editar</a></li>
                          <li style="padding: 0 .4rem;"><a href="#" class="dropdown-item btn-delete" style="padding: .8rem; border-radius: 5px;">Eliminar</a></li>
                        </ul>`;
                      }
                    }],
                    columnDefs: [{
                      targets: -1,
                      orderable: false
                    }],
                    "responsive": true,
                    "lengthChange": false,
                    "autoWidth": false,
                    "language": idiomaPortugues,
                    lengthMenu: [
                      [7, 25, 50, -1],
                      [10, 25, 50, 'All']
                    ],
                    "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                  }).buttons().container().appendTo('#tabelaClasseMovimento_wrapper .col-md-6:eq(0)');
        },
        function error(data) {
            erro(data);
        },
        function done(data) {
            
        });

        funcaoSelect("../pos/includes/select.inc.php", "post", "json", "tipopatrimonio", function success(data) {

            var selecttipo = '<option value="" selected disabled>-- Selecione o Tipo de Bem Patrimonial --</option>';
            for (var i = 0; i < data.length; i++) {
                
                selecttipo += `<option value="${data[i]['idTipopatrimonio']}">${data[i]['tipopatrimonio']}</option>`
            }
            tipopatrimonio.innerHTML = selecttipo;
        },
        function error(data) {
            erro(data);
        },
        function done(data) {
            
        });

        funcaoSelect("../pos/includes/select.inc.php", "post", "json", "armazem", function success(data) {

            var selectarmazem = '<option value="" selected disabled>-- Selecione a Localização --</option>';
            for (var i = 0; i < data.length; i++) {
                
                selectarmazem += `<option value="${data[i]['nome']}">${data[i]['nome']}</option>`
            }
                selectarmazem += ` <option value="own-localization">Informar outra Localização</option>`
            localizacao.innerHTML = selectarmazem;
        },
        function error(data) {
            erro(data);
        },
        function done(data) {
            
        });

        
    
    $('#tabelaClasseMovimento').on('click', '.btn-update', function(e) {
   /* e.preventDefault();
    linha = $(this).closest('tr').find('td');
    doOpcao.innerText = "Editar Artigo";
    resetForm();
    $('#modal-documento').modal('show');*/
    let id = $(this).closest('tr').find('td')[0].textContent;
    alert(id)
    $('#modal-documento-update').modal('show');
    $('#tipocxbk-update').change(function() {
            if ($(this).val() == 2) {
                $('.onlyBank').removeClass('d-none');
            } else {
                $('.onlyBank').addClass('d-none');
            }
        });
    detalhes(id)
    function detalhes(id) {
    funcaoQuerySelect("../pos/includes/querySelect.inc.php", "post", "json", {
      idCaixabanco: id
    }, "caixabanco", function success(data) {
      for (var key in data) {
        $('#id_caixa_banco').val(id);
         $('#saldo-update').val(data[key]["saldo"]);
        $('#nconta-update').val(data[key]["numeroconta"]);
        $('#iban-update').val(data[key]["iban"]);
        $('#swift-update').val(data[key]["swift"]);
        $('#descricao-update').val(data[key]["descricao"]);
      }
    }, function error(data) {

    }, function done(data) {

    });
  }

  
  });

  $('#tabelaClasseMovimento').on('click', '.btn-delete', function(e) {
   /* e.preventDefault();
    linha = $(this).closest('tr').find('td');
    doOpcao.innerText = "Editar Artigo";
    resetForm();
    $('#modal-documento').modal('show');*/
    let id = $(this).closest('tr').find('td')[0].textContent;
    funcaoDelete("../pos/includes/delete.inc.php", "post", "json", "caixabanco", {
            idCaixabanco: id
          }, function success(data) {
            console.log(data);
            swal.fire({
              title: "Dados eliminado com sucesso!",
              icon: "success",
              confirmButtonText: 'Confirmar',
              confirmButtonColor: '#560085',
            });
            window.location.href ="formParametroCaixaBanco.php"
          }, function error(data) {
            console.log(data);
            swal.fire({
              title: "Erro ao eliminar Tipo de Usuário!",
              text: "Tipo de Usuário associado a uma ou mais Documentos.",
              icon: "error",
              confirmButtonText: 'Confirmar',
              confirmButtonColor: '#560085',
            });
          }, function done(data) {

          });

  
  });    


    $('#updateCaixaBanco').click(function(e){
        var idCaixabanc = $('#id_caixa_banco').val();
        var tipocxbk = $('#tipocxbk-update').val();
        var saldo = $('#saldo-update').val();
        var nconta = $('#nconta-update').val();
        var iban = $('#iban-update').val();
        var swift = $('#swift-update').val();
        var descricao = $('#descricao-update').val();
        var outra_localizacao = $('#outra_localizacao').val();

        let currentObjectData = {
                    idUsuario: <?php echo $_SESSION["usuarioId"]; ?>,
                    idTipoCaixaBanco: tipocxbk,
                    saldo : saldo,
                    numeroconta: nconta,
                    iban : iban,
                    swift : swift,
                    descricao : descricao,
            }

        if (tipocxbk != null && (descricao != null && descricao != '')) {
            funcaoUpdate("../pos/includes/update.inc.php", "post", "json", "caixabanco", currentObjectData, {
                    idCaixabanco: idCaixabanc
                  }, function success(data) {
                    swal.fire({
                      title: "Feito!",
                      text: "Informações Actualizadas com sucesso!",
                      confirmButtonText: 'Confirmar',
                      confirmButtonColor: '#560085',
                      icon: "success",
                    });
                    window.location.href ="formParametroCaixaBanco.php"
                  }, function error(data) {
                    console.log("Erro: ", data);
                    swal.fire({
                      title: "Erro ao actualizar!",
                      text: "Erro ao actualizar Dados Submetidos!",
                      confirmButtonText: 'Confirmar',
                      confirmButtonColor: '#560085',
                      icon: "error",
                    });
                  }, function done(data) {

                });
            }

        });


        $('#preco_compra').on('keyup', function(){
            calcular_amortizacao()
        });
        $('#preco_venda').on('keyup', function(){
            calcular_amortizacao()
        });
        $('#idade_bem').on('keyup', function(){
            calcular_amortizacao()
        });


        function calcular_amortizacao()
        {
            var preco_compra = $('#preco_compra').val();
            var preco_venda = $('#preco_venda').val();
            var idade_bem = $('#idade_bem').val();
            if ((preco_compra != null && idade_bem != null && preco_venda != null) && (preco_compra != undefined && idade_bem != undefined && preco_venda != undefined) && (preco_compra != '' && idade_bem != '' && preco_venda != '')) {

                var auxxVA = ((Number(preco_compra) - Number(preco_venda)) / Number(idade_bem))
                var auxxTA = ((Number(auxxVA) / Number(preco_compra)) * 100)

                $('#tax_amotizacao').val(auxxTA.toFixed(2)+'%');
                $('#valor_amortizacao').val(auxxVA.toFixed(2));

                $('#div-tax-amort').removeClass('invisible');
                $('#div-valor-amort').removeClass('invisible');
            }else{
                $('#div-tax-amort').addClass('invisible');
                $('#div-valor-amort').addClass('invisible');
            }
        }

        $('#gravarpartimonio').click(function(e){

        var tipopatrimonio = $('#tipopatrimonio').val();
        var code = $('#code').val();
        
        var preco_compra = $('#preco_compra').val();
        var preco_venda = $('#preco_venda').val();
        var localizacao = $('#localizacao').val();
        var patrimonio_ = $('#patrimonio_').val();
        var idade_bem = $('#idade_bem').val();
        var outra_localizacao = $('#outra_localizacao').val();

        

        var tax_amotizacao = $('#tax_amotizacao').val();
        var valor_amortizacao = $('#valor_amortizacao').val();

        //if (outra_localizacao != undefined) {localizacao =  outra_localizacao}



        let currentObjectData = {
                    idUsuario: <?php echo $_SESSION["usuarioId"]; ?>,
                    patrimonio: patrimonio_,
                    idTipopatrimonio : tipopatrimonio,
                    tax_amortizacao: tax_amotizacao.split('%')[0],
                    valor_amortizacao : valor_amortizacao,
                    preco_custo : preco_compra,
                    preco_venda : preco_venda,
                    idade_bem: idade_bem,
                    localizacao: localizacao,
                    codigo: code
            }

        if (tipopatrimonio != null && (patrimonio_ != null && patrimonio_ != '')) {
            funcaoInsert("../pos/includes/insert.inc.php", "post", "json", 'patrimonio', currentObjectData, function success(data) {}, function error(data) {
                console.log(data)
                     swal.fire({
                        title: "Erro ao cadastrar!",
                        text: "Erro ao cadastrar coordenadas! ",//+ nome.value + " !",
                        confirmButtonText: 'Confirmar',
                        confirmButtonColor: '#560085',
                        icon: "error",
                     });
                  }, function done(data) {
                     swal.fire({
                        title: "Cadatrado",
                        text: "Os dados Submetidos foram cadastrados com sucesso!",
                        icon: "success",
                        confirmButtonText: 'Confirmar',
                        confirmButtonColor: '#560085',
                     });
                     window.location.href ="formPatrimonio.php"
                  });
            }

        });

</script>

<script src=""></script>